/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.ListPolicyAttachmentsRequest;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class ListPolicyAttachmentsRequestMarshaller
implements Marshaller<Request<ListPolicyAttachmentsRequest>, ListPolicyAttachmentsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListPolicyAttachmentsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<ListPolicyAttachmentsRequest> marshall(ListPolicyAttachmentsRequest listPolicyAttachmentsRequest) {
        if (listPolicyAttachmentsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)listPolicyAttachmentsRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (listPolicyAttachmentsRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)listPolicyAttachmentsRequest.getDirectoryArn()));
        }
        if (listPolicyAttachmentsRequest.getConsistencyLevel() != null) {
            request.addHeader("x-amz-consistency-level", StringUtils.fromString((String)listPolicyAttachmentsRequest.getConsistencyLevel()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/policy/attachment";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listPolicyAttachmentsRequest.getPolicyReference() != null) {
                jsonGenerator.writeFieldName("PolicyReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(listPolicyAttachmentsRequest.getPolicyReference(), jsonGenerator);
            }
            if (listPolicyAttachmentsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listPolicyAttachmentsRequest.getNextToken());
            }
            if (listPolicyAttachmentsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listPolicyAttachmentsRequest.getMaxResults().intValue());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

