/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.ObjectAttributeUpdate;
import com.amazonaws.services.clouddirectory.model.UpdateObjectAttributesRequest;
import com.amazonaws.services.clouddirectory.model.transform.ObjectAttributeUpdateJsonMarshaller;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;

public class UpdateObjectAttributesRequestMarshaller
implements Marshaller<Request<UpdateObjectAttributesRequest>, UpdateObjectAttributesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateObjectAttributesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<UpdateObjectAttributesRequest> marshall(UpdateObjectAttributesRequest updateObjectAttributesRequest) {
        if (updateObjectAttributesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)updateObjectAttributesRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.PUT);
        if (updateObjectAttributesRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString((String)updateObjectAttributesRequest.getDirectoryArn()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/object/update";
        request.setResourcePath(uriResourcePath);
        try {
            List<ObjectAttributeUpdate> attributeUpdatesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateObjectAttributesRequest.getObjectReference() != null) {
                jsonGenerator.writeFieldName("ObjectReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(updateObjectAttributesRequest.getObjectReference(), jsonGenerator);
            }
            if ((attributeUpdatesList = updateObjectAttributesRequest.getAttributeUpdates()) != null) {
                jsonGenerator.writeFieldName("AttributeUpdates");
                jsonGenerator.writeStartArray();
                for (ObjectAttributeUpdate attributeUpdatesListValue : attributeUpdatesList) {
                    if (attributeUpdatesListValue == null) continue;
                    ObjectAttributeUpdateJsonMarshaller.getInstance().marshall(attributeUpdatesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

