/*
 * Copyright 2020-2025 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanroomsml.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/cleanroomsml-2023-09-06/ListTrainingDatasets" target="_top">AWS
 *      API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListTrainingDatasetsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     */
    private String nextToken;
    /**
     * <p>
     * The training datasets that match the request.
     * </p>
     */
    private java.util.List<TrainingDatasetSummary> trainingDatasets;

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @param nextToken
     *        The token value retrieved from a previous call to access the next page of results.
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @return The token value retrieved from a previous call to access the next page of results.
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * <p>
     * The token value retrieved from a previous call to access the next page of results.
     * </p>
     * 
     * @param nextToken
     *        The token value retrieved from a previous call to access the next page of results.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTrainingDatasetsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * <p>
     * The training datasets that match the request.
     * </p>
     * 
     * @return The training datasets that match the request.
     */

    public java.util.List<TrainingDatasetSummary> getTrainingDatasets() {
        return trainingDatasets;
    }

    /**
     * <p>
     * The training datasets that match the request.
     * </p>
     * 
     * @param trainingDatasets
     *        The training datasets that match the request.
     */

    public void setTrainingDatasets(java.util.Collection<TrainingDatasetSummary> trainingDatasets) {
        if (trainingDatasets == null) {
            this.trainingDatasets = null;
            return;
        }

        this.trainingDatasets = new java.util.ArrayList<TrainingDatasetSummary>(trainingDatasets);
    }

    /**
     * <p>
     * The training datasets that match the request.
     * </p>
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setTrainingDatasets(java.util.Collection)} or {@link #withTrainingDatasets(java.util.Collection)} if you
     * want to override the existing values.
     * </p>
     * 
     * @param trainingDatasets
     *        The training datasets that match the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTrainingDatasetsResult withTrainingDatasets(TrainingDatasetSummary... trainingDatasets) {
        if (this.trainingDatasets == null) {
            setTrainingDatasets(new java.util.ArrayList<TrainingDatasetSummary>(trainingDatasets.length));
        }
        for (TrainingDatasetSummary ele : trainingDatasets) {
            this.trainingDatasets.add(ele);
        }
        return this;
    }

    /**
     * <p>
     * The training datasets that match the request.
     * </p>
     * 
     * @param trainingDatasets
     *        The training datasets that match the request.
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListTrainingDatasetsResult withTrainingDatasets(java.util.Collection<TrainingDatasetSummary> trainingDatasets) {
        setTrainingDatasets(trainingDatasets);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken()).append(",");
        if (getTrainingDatasets() != null)
            sb.append("TrainingDatasets: ").append(getTrainingDatasets());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListTrainingDatasetsResult == false)
            return false;
        ListTrainingDatasetsResult other = (ListTrainingDatasetsResult) obj;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        if (other.getTrainingDatasets() == null ^ this.getTrainingDatasets() == null)
            return false;
        if (other.getTrainingDatasets() != null && other.getTrainingDatasets().equals(this.getTrainingDatasets()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        hashCode = prime * hashCode + ((getTrainingDatasets() == null) ? 0 : getTrainingDatasets().hashCode());
        return hashCode;
    }

    @Override
    public ListTrainingDatasetsResult clone() {
        try {
            return (ListTrainingDatasetsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
