/*
 * Copyright 2019-2024 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.cleanroomsml;

import javax.annotation.Generated;

import com.amazonaws.services.cleanroomsml.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AWSCleanRoomsML}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAWSCleanRoomsML implements AWSCleanRoomsML {

    protected AbstractAWSCleanRoomsML() {
    }

    @Override
    public CreateAudienceModelResult createAudienceModel(CreateAudienceModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateConfiguredAudienceModelResult createConfiguredAudienceModel(CreateConfiguredAudienceModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public CreateTrainingDatasetResult createTrainingDataset(CreateTrainingDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAudienceGenerationJobResult deleteAudienceGenerationJob(DeleteAudienceGenerationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteAudienceModelResult deleteAudienceModel(DeleteAudienceModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConfiguredAudienceModelResult deleteConfiguredAudienceModel(DeleteConfiguredAudienceModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConfiguredAudienceModelPolicyResult deleteConfiguredAudienceModelPolicy(DeleteConfiguredAudienceModelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteTrainingDatasetResult deleteTrainingDataset(DeleteTrainingDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAudienceGenerationJobResult getAudienceGenerationJob(GetAudienceGenerationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetAudienceModelResult getAudienceModel(GetAudienceModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfiguredAudienceModelResult getConfiguredAudienceModel(GetConfiguredAudienceModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConfiguredAudienceModelPolicyResult getConfiguredAudienceModelPolicy(GetConfiguredAudienceModelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetTrainingDatasetResult getTrainingDataset(GetTrainingDatasetRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAudienceExportJobsResult listAudienceExportJobs(ListAudienceExportJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAudienceGenerationJobsResult listAudienceGenerationJobs(ListAudienceGenerationJobsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListAudienceModelsResult listAudienceModels(ListAudienceModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListConfiguredAudienceModelsResult listConfiguredAudienceModels(ListConfiguredAudienceModelsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTrainingDatasetsResult listTrainingDatasets(ListTrainingDatasetsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutConfiguredAudienceModelPolicyResult putConfiguredAudienceModelPolicy(PutConfiguredAudienceModelPolicyRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAudienceExportJobResult startAudienceExportJob(StartAudienceExportJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartAudienceGenerationJobResult startAudienceGenerationJob(StartAudienceGenerationJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateConfiguredAudienceModelResult updateConfiguredAudienceModel(UpdateConfiguredAudienceModelRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
