/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanrooms.model.AnalysisRuleType;
import com.amazonaws.services.cleanrooms.model.AnalysisType;
import com.amazonaws.services.cleanrooms.model.SchemaConfiguration;
import com.amazonaws.services.cleanrooms.model.SchemaStatus;
import com.amazonaws.services.cleanrooms.model.SchemaStatusReason;
import com.amazonaws.services.cleanrooms.model.transform.SchemaStatusDetailMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SchemaStatusDetail
implements Serializable,
Cloneable,
StructuredPojo {
    private String status;
    private List<SchemaStatusReason> reasons;
    private String analysisRuleType;
    private List<String> configurations;
    private String analysisType;

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public SchemaStatusDetail withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public SchemaStatusDetail withStatus(SchemaStatus status) {
        this.status = status.toString();
        return this;
    }

    public List<SchemaStatusReason> getReasons() {
        return this.reasons;
    }

    public void setReasons(Collection<SchemaStatusReason> reasons) {
        if (reasons == null) {
            this.reasons = null;
            return;
        }
        this.reasons = new ArrayList<SchemaStatusReason>(reasons);
    }

    public SchemaStatusDetail withReasons(SchemaStatusReason ... reasons) {
        if (this.reasons == null) {
            this.setReasons(new ArrayList<SchemaStatusReason>(reasons.length));
        }
        for (SchemaStatusReason ele : reasons) {
            this.reasons.add(ele);
        }
        return this;
    }

    public SchemaStatusDetail withReasons(Collection<SchemaStatusReason> reasons) {
        this.setReasons(reasons);
        return this;
    }

    public void setAnalysisRuleType(String analysisRuleType) {
        this.analysisRuleType = analysisRuleType;
    }

    public String getAnalysisRuleType() {
        return this.analysisRuleType;
    }

    public SchemaStatusDetail withAnalysisRuleType(String analysisRuleType) {
        this.setAnalysisRuleType(analysisRuleType);
        return this;
    }

    public SchemaStatusDetail withAnalysisRuleType(AnalysisRuleType analysisRuleType) {
        this.analysisRuleType = analysisRuleType.toString();
        return this;
    }

    public List<String> getConfigurations() {
        return this.configurations;
    }

    public void setConfigurations(Collection<String> configurations) {
        if (configurations == null) {
            this.configurations = null;
            return;
        }
        this.configurations = new ArrayList<String>(configurations);
    }

    public SchemaStatusDetail withConfigurations(String ... configurations) {
        if (this.configurations == null) {
            this.setConfigurations(new ArrayList<String>(configurations.length));
        }
        for (String ele : configurations) {
            this.configurations.add(ele);
        }
        return this;
    }

    public SchemaStatusDetail withConfigurations(Collection<String> configurations) {
        this.setConfigurations(configurations);
        return this;
    }

    public SchemaStatusDetail withConfigurations(SchemaConfiguration ... configurations) {
        ArrayList<String> configurationsCopy = new ArrayList<String>(configurations.length);
        for (SchemaConfiguration value : configurations) {
            configurationsCopy.add(value.toString());
        }
        if (this.getConfigurations() == null) {
            this.setConfigurations(configurationsCopy);
        } else {
            this.getConfigurations().addAll(configurationsCopy);
        }
        return this;
    }

    public void setAnalysisType(String analysisType) {
        this.analysisType = analysisType;
    }

    public String getAnalysisType() {
        return this.analysisType;
    }

    public SchemaStatusDetail withAnalysisType(String analysisType) {
        this.setAnalysisType(analysisType);
        return this;
    }

    public SchemaStatusDetail withAnalysisType(AnalysisType analysisType) {
        this.analysisType = analysisType.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getReasons() != null) {
            sb.append("Reasons: ").append(this.getReasons()).append(",");
        }
        if (this.getAnalysisRuleType() != null) {
            sb.append("AnalysisRuleType: ").append(this.getAnalysisRuleType()).append(",");
        }
        if (this.getConfigurations() != null) {
            sb.append("Configurations: ").append(this.getConfigurations()).append(",");
        }
        if (this.getAnalysisType() != null) {
            sb.append("AnalysisType: ").append(this.getAnalysisType());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaStatusDetail)) {
            return false;
        }
        SchemaStatusDetail other = (SchemaStatusDetail)obj;
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getReasons() == null ^ this.getReasons() == null) {
            return false;
        }
        if (other.getReasons() != null && !other.getReasons().equals(this.getReasons())) {
            return false;
        }
        if (other.getAnalysisRuleType() == null ^ this.getAnalysisRuleType() == null) {
            return false;
        }
        if (other.getAnalysisRuleType() != null && !other.getAnalysisRuleType().equals(this.getAnalysisRuleType())) {
            return false;
        }
        if (other.getConfigurations() == null ^ this.getConfigurations() == null) {
            return false;
        }
        if (other.getConfigurations() != null && !other.getConfigurations().equals(this.getConfigurations())) {
            return false;
        }
        if (other.getAnalysisType() == null ^ this.getAnalysisType() == null) {
            return false;
        }
        return other.getAnalysisType() == null || other.getAnalysisType().equals(this.getAnalysisType());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getReasons() == null ? 0 : this.getReasons().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisRuleType() == null ? 0 : this.getAnalysisRuleType().hashCode());
        hashCode = 31 * hashCode + (this.getConfigurations() == null ? 0 : this.getConfigurations().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysisType() == null ? 0 : this.getAnalysisType().hashCode());
        return hashCode;
    }

    public SchemaStatusDetail clone() {
        try {
            return (SchemaStatusDetail)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        SchemaStatusDetailMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

