/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cleanrooms.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.cleanrooms.model.JoinOperator;
import com.amazonaws.services.cleanrooms.model.transform.AnalysisRuleListMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class AnalysisRuleList
implements Serializable,
Cloneable,
StructuredPojo {
    private List<String> joinColumns;
    private List<String> allowedJoinOperators;
    private List<String> listColumns;

    public List<String> getJoinColumns() {
        return this.joinColumns;
    }

    public void setJoinColumns(Collection<String> joinColumns) {
        if (joinColumns == null) {
            this.joinColumns = null;
            return;
        }
        this.joinColumns = new ArrayList<String>(joinColumns);
    }

    public AnalysisRuleList withJoinColumns(String ... joinColumns) {
        if (this.joinColumns == null) {
            this.setJoinColumns(new ArrayList<String>(joinColumns.length));
        }
        for (String ele : joinColumns) {
            this.joinColumns.add(ele);
        }
        return this;
    }

    public AnalysisRuleList withJoinColumns(Collection<String> joinColumns) {
        this.setJoinColumns(joinColumns);
        return this;
    }

    public List<String> getAllowedJoinOperators() {
        return this.allowedJoinOperators;
    }

    public void setAllowedJoinOperators(Collection<String> allowedJoinOperators) {
        if (allowedJoinOperators == null) {
            this.allowedJoinOperators = null;
            return;
        }
        this.allowedJoinOperators = new ArrayList<String>(allowedJoinOperators);
    }

    public AnalysisRuleList withAllowedJoinOperators(String ... allowedJoinOperators) {
        if (this.allowedJoinOperators == null) {
            this.setAllowedJoinOperators(new ArrayList<String>(allowedJoinOperators.length));
        }
        for (String ele : allowedJoinOperators) {
            this.allowedJoinOperators.add(ele);
        }
        return this;
    }

    public AnalysisRuleList withAllowedJoinOperators(Collection<String> allowedJoinOperators) {
        this.setAllowedJoinOperators(allowedJoinOperators);
        return this;
    }

    public AnalysisRuleList withAllowedJoinOperators(JoinOperator ... allowedJoinOperators) {
        ArrayList<String> allowedJoinOperatorsCopy = new ArrayList<String>(allowedJoinOperators.length);
        for (JoinOperator value : allowedJoinOperators) {
            allowedJoinOperatorsCopy.add(value.toString());
        }
        if (this.getAllowedJoinOperators() == null) {
            this.setAllowedJoinOperators(allowedJoinOperatorsCopy);
        } else {
            this.getAllowedJoinOperators().addAll(allowedJoinOperatorsCopy);
        }
        return this;
    }

    public List<String> getListColumns() {
        return this.listColumns;
    }

    public void setListColumns(Collection<String> listColumns) {
        if (listColumns == null) {
            this.listColumns = null;
            return;
        }
        this.listColumns = new ArrayList<String>(listColumns);
    }

    public AnalysisRuleList withListColumns(String ... listColumns) {
        if (this.listColumns == null) {
            this.setListColumns(new ArrayList<String>(listColumns.length));
        }
        for (String ele : listColumns) {
            this.listColumns.add(ele);
        }
        return this;
    }

    public AnalysisRuleList withListColumns(Collection<String> listColumns) {
        this.setListColumns(listColumns);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getJoinColumns() != null) {
            sb.append("JoinColumns: ").append(this.getJoinColumns()).append(",");
        }
        if (this.getAllowedJoinOperators() != null) {
            sb.append("AllowedJoinOperators: ").append(this.getAllowedJoinOperators()).append(",");
        }
        if (this.getListColumns() != null) {
            sb.append("ListColumns: ").append(this.getListColumns());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnalysisRuleList)) {
            return false;
        }
        AnalysisRuleList other = (AnalysisRuleList)obj;
        if (other.getJoinColumns() == null ^ this.getJoinColumns() == null) {
            return false;
        }
        if (other.getJoinColumns() != null && !other.getJoinColumns().equals(this.getJoinColumns())) {
            return false;
        }
        if (other.getAllowedJoinOperators() == null ^ this.getAllowedJoinOperators() == null) {
            return false;
        }
        if (other.getAllowedJoinOperators() != null && !other.getAllowedJoinOperators().equals(this.getAllowedJoinOperators())) {
            return false;
        }
        if (other.getListColumns() == null ^ this.getListColumns() == null) {
            return false;
        }
        return other.getListColumns() == null || other.getListColumns().equals(this.getListColumns());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getJoinColumns() == null ? 0 : this.getJoinColumns().hashCode());
        hashCode = 31 * hashCode + (this.getAllowedJoinOperators() == null ? 0 : this.getAllowedJoinOperators().hashCode());
        hashCode = 31 * hashCode + (this.getListColumns() == null ? 0 : this.getListColumns().hashCode());
        return hashCode;
    }

    public AnalysisRuleList clone() {
        try {
            return (AnalysisRuleList)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AnalysisRuleListMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

