/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.chimesdkvoice.model;

import java.io.Serializable;
import javax.annotation.Generated;

/**
 * 
 * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/chime-sdk-voice-2022-08-03/ListSipMediaApplications"
 *      target="_top">AWS API Documentation</a>
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class ListSipMediaApplicationsResult extends com.amazonaws.AmazonWebServiceResult<com.amazonaws.ResponseMetadata> implements Serializable, Cloneable {

    private java.util.List<SipMediaApplication> sipMediaApplications;

    private String nextToken;

    /**
     * @return
     */

    public java.util.List<SipMediaApplication> getSipMediaApplications() {
        return sipMediaApplications;
    }

    /**
     * @param sipMediaApplications
     */

    public void setSipMediaApplications(java.util.Collection<SipMediaApplication> sipMediaApplications) {
        if (sipMediaApplications == null) {
            this.sipMediaApplications = null;
            return;
        }

        this.sipMediaApplications = new java.util.ArrayList<SipMediaApplication>(sipMediaApplications);
    }

    /**
     * <p>
     * <b>NOTE:</b> This method appends the values to the existing list (if any). Use
     * {@link #setSipMediaApplications(java.util.Collection)} or {@link #withSipMediaApplications(java.util.Collection)}
     * if you want to override the existing values.
     * </p>
     * 
     * @param sipMediaApplications
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSipMediaApplicationsResult withSipMediaApplications(SipMediaApplication... sipMediaApplications) {
        if (this.sipMediaApplications == null) {
            setSipMediaApplications(new java.util.ArrayList<SipMediaApplication>(sipMediaApplications.length));
        }
        for (SipMediaApplication ele : sipMediaApplications) {
            this.sipMediaApplications.add(ele);
        }
        return this;
    }

    /**
     * @param sipMediaApplications
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSipMediaApplicationsResult withSipMediaApplications(java.util.Collection<SipMediaApplication> sipMediaApplications) {
        setSipMediaApplications(sipMediaApplications);
        return this;
    }

    /**
     * @param nextToken
     */

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    /**
     * @return
     */

    public String getNextToken() {
        return this.nextToken;
    }

    /**
     * @param nextToken
     * @return Returns a reference to this object so that method calls can be chained together.
     */

    public ListSipMediaApplicationsResult withNextToken(String nextToken) {
        setNextToken(nextToken);
        return this;
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     *
     * @return A string representation of this object.
     *
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (getSipMediaApplications() != null)
            sb.append("SipMediaApplications: ").append(getSipMediaApplications()).append(",");
        if (getNextToken() != null)
            sb.append("NextToken: ").append(getNextToken());
        sb.append("}");
        return sb.toString();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;

        if (obj instanceof ListSipMediaApplicationsResult == false)
            return false;
        ListSipMediaApplicationsResult other = (ListSipMediaApplicationsResult) obj;
        if (other.getSipMediaApplications() == null ^ this.getSipMediaApplications() == null)
            return false;
        if (other.getSipMediaApplications() != null && other.getSipMediaApplications().equals(this.getSipMediaApplications()) == false)
            return false;
        if (other.getNextToken() == null ^ this.getNextToken() == null)
            return false;
        if (other.getNextToken() != null && other.getNextToken().equals(this.getNextToken()) == false)
            return false;
        return true;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int hashCode = 1;

        hashCode = prime * hashCode + ((getSipMediaApplications() == null) ? 0 : getSipMediaApplications().hashCode());
        hashCode = prime * hashCode + ((getNextToken() == null) ? 0 : getNextToken().hashCode());
        return hashCode;
    }

    @Override
    public ListSipMediaApplicationsResult clone() {
        try {
            return (ListSipMediaApplicationsResult) super.clone();
        } catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() " + "even though we're Cloneable!", e);
        }
    }

}
