/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chimesdkmessaging.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chimesdkmessaging.model.Processor;
import com.amazonaws.services.chimesdkmessaging.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateChannelFlowRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String appInstanceArn;
    private List<Processor> processors;
    private String name;
    private List<Tag> tags;
    private String clientRequestToken;

    public void setAppInstanceArn(String appInstanceArn) {
        this.appInstanceArn = appInstanceArn;
    }

    public String getAppInstanceArn() {
        return this.appInstanceArn;
    }

    public CreateChannelFlowRequest withAppInstanceArn(String appInstanceArn) {
        this.setAppInstanceArn(appInstanceArn);
        return this;
    }

    public List<Processor> getProcessors() {
        return this.processors;
    }

    public void setProcessors(Collection<Processor> processors) {
        if (processors == null) {
            this.processors = null;
            return;
        }
        this.processors = new ArrayList<Processor>(processors);
    }

    public CreateChannelFlowRequest withProcessors(Processor ... processors) {
        if (this.processors == null) {
            this.setProcessors(new ArrayList<Processor>(processors.length));
        }
        for (Processor ele : processors) {
            this.processors.add(ele);
        }
        return this;
    }

    public CreateChannelFlowRequest withProcessors(Collection<Processor> processors) {
        this.setProcessors(processors);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateChannelFlowRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateChannelFlowRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateChannelFlowRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setClientRequestToken(String clientRequestToken) {
        this.clientRequestToken = clientRequestToken;
    }

    public String getClientRequestToken() {
        return this.clientRequestToken;
    }

    public CreateChannelFlowRequest withClientRequestToken(String clientRequestToken) {
        this.setClientRequestToken(clientRequestToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAppInstanceArn() != null) {
            sb.append("AppInstanceArn: ").append(this.getAppInstanceArn()).append(",");
        }
        if (this.getProcessors() != null) {
            sb.append("Processors: ").append(this.getProcessors()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getClientRequestToken() != null) {
            sb.append("ClientRequestToken: ").append("***Sensitive Data Redacted***");
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateChannelFlowRequest)) {
            return false;
        }
        CreateChannelFlowRequest other = (CreateChannelFlowRequest)obj;
        if (other.getAppInstanceArn() == null ^ this.getAppInstanceArn() == null) {
            return false;
        }
        if (other.getAppInstanceArn() != null && !other.getAppInstanceArn().equals(this.getAppInstanceArn())) {
            return false;
        }
        if (other.getProcessors() == null ^ this.getProcessors() == null) {
            return false;
        }
        if (other.getProcessors() != null && !other.getProcessors().equals(this.getProcessors())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getClientRequestToken() == null ^ this.getClientRequestToken() == null) {
            return false;
        }
        return other.getClientRequestToken() == null || other.getClientRequestToken().equals(this.getClientRequestToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAppInstanceArn() == null ? 0 : this.getAppInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getProcessors() == null ? 0 : this.getProcessors().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getClientRequestToken() == null ? 0 : this.getClientRequestToken().hashCode());
        return hashCode;
    }

    public CreateChannelFlowRequest clone() {
        return (CreateChannelFlowRequest)super.clone();
    }
}

