/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chime.model.ChannelMembershipType;
import com.amazonaws.services.chime.model.Identity;
import com.amazonaws.services.chime.model.transform.BatchChannelMembershipsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchChannelMemberships
implements Serializable,
Cloneable,
StructuredPojo {
    private Identity invitedBy;
    private String type;
    private List<Identity> members;
    private String channelArn;

    public void setInvitedBy(Identity invitedBy) {
        this.invitedBy = invitedBy;
    }

    public Identity getInvitedBy() {
        return this.invitedBy;
    }

    public BatchChannelMemberships withInvitedBy(Identity invitedBy) {
        this.setInvitedBy(invitedBy);
        return this;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public BatchChannelMemberships withType(String type) {
        this.setType(type);
        return this;
    }

    public BatchChannelMemberships withType(ChannelMembershipType type) {
        this.type = type.toString();
        return this;
    }

    public List<Identity> getMembers() {
        return this.members;
    }

    public void setMembers(Collection<Identity> members) {
        if (members == null) {
            this.members = null;
            return;
        }
        this.members = new ArrayList<Identity>(members);
    }

    public BatchChannelMemberships withMembers(Identity ... members) {
        if (this.members == null) {
            this.setMembers(new ArrayList<Identity>(members.length));
        }
        for (Identity ele : members) {
            this.members.add(ele);
        }
        return this;
    }

    public BatchChannelMemberships withMembers(Collection<Identity> members) {
        this.setMembers(members);
        return this;
    }

    public void setChannelArn(String channelArn) {
        this.channelArn = channelArn;
    }

    public String getChannelArn() {
        return this.channelArn;
    }

    public BatchChannelMemberships withChannelArn(String channelArn) {
        this.setChannelArn(channelArn);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getInvitedBy() != null) {
            sb.append("InvitedBy: ").append(this.getInvitedBy()).append(",");
        }
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getMembers() != null) {
            sb.append("Members: ").append(this.getMembers()).append(",");
        }
        if (this.getChannelArn() != null) {
            sb.append("ChannelArn: ").append(this.getChannelArn());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchChannelMemberships)) {
            return false;
        }
        BatchChannelMemberships other = (BatchChannelMemberships)obj;
        if (other.getInvitedBy() == null ^ this.getInvitedBy() == null) {
            return false;
        }
        if (other.getInvitedBy() != null && !other.getInvitedBy().equals(this.getInvitedBy())) {
            return false;
        }
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getMembers() == null ^ this.getMembers() == null) {
            return false;
        }
        if (other.getMembers() != null && !other.getMembers().equals(this.getMembers())) {
            return false;
        }
        if (other.getChannelArn() == null ^ this.getChannelArn() == null) {
            return false;
        }
        return other.getChannelArn() == null || other.getChannelArn().equals(this.getChannelArn());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getInvitedBy() == null ? 0 : this.getInvitedBy().hashCode());
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getMembers() == null ? 0 : this.getMembers().hashCode());
        hashCode = 31 * hashCode + (this.getChannelArn() == null ? 0 : this.getChannelArn().hashCode());
        return hashCode;
    }

    public BatchChannelMemberships clone() {
        try {
            return (BatchChannelMemberships)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        BatchChannelMembershipsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

