/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chime.model.Capability;
import com.amazonaws.services.chime.model.GeoMatchLevel;
import com.amazonaws.services.chime.model.GeoMatchParams;
import com.amazonaws.services.chime.model.NumberSelectionBehavior;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateProxySessionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String voiceConnectorId;
    private List<String> participantPhoneNumbers;
    private String name;
    private Integer expiryMinutes;
    private List<String> capabilities;
    private String numberSelectionBehavior;
    private String geoMatchLevel;
    private GeoMatchParams geoMatchParams;

    public void setVoiceConnectorId(String voiceConnectorId) {
        this.voiceConnectorId = voiceConnectorId;
    }

    public String getVoiceConnectorId() {
        return this.voiceConnectorId;
    }

    public CreateProxySessionRequest withVoiceConnectorId(String voiceConnectorId) {
        this.setVoiceConnectorId(voiceConnectorId);
        return this;
    }

    public List<String> getParticipantPhoneNumbers() {
        return this.participantPhoneNumbers;
    }

    public void setParticipantPhoneNumbers(Collection<String> participantPhoneNumbers) {
        if (participantPhoneNumbers == null) {
            this.participantPhoneNumbers = null;
            return;
        }
        this.participantPhoneNumbers = new ArrayList<String>(participantPhoneNumbers);
    }

    public CreateProxySessionRequest withParticipantPhoneNumbers(String ... participantPhoneNumbers) {
        if (this.participantPhoneNumbers == null) {
            this.setParticipantPhoneNumbers(new ArrayList<String>(participantPhoneNumbers.length));
        }
        for (String ele : participantPhoneNumbers) {
            this.participantPhoneNumbers.add(ele);
        }
        return this;
    }

    public CreateProxySessionRequest withParticipantPhoneNumbers(Collection<String> participantPhoneNumbers) {
        this.setParticipantPhoneNumbers(participantPhoneNumbers);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateProxySessionRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setExpiryMinutes(Integer expiryMinutes) {
        this.expiryMinutes = expiryMinutes;
    }

    public Integer getExpiryMinutes() {
        return this.expiryMinutes;
    }

    public CreateProxySessionRequest withExpiryMinutes(Integer expiryMinutes) {
        this.setExpiryMinutes(expiryMinutes);
        return this;
    }

    public List<String> getCapabilities() {
        return this.capabilities;
    }

    public void setCapabilities(Collection<String> capabilities) {
        if (capabilities == null) {
            this.capabilities = null;
            return;
        }
        this.capabilities = new ArrayList<String>(capabilities);
    }

    public CreateProxySessionRequest withCapabilities(String ... capabilities) {
        if (this.capabilities == null) {
            this.setCapabilities(new ArrayList<String>(capabilities.length));
        }
        for (String ele : capabilities) {
            this.capabilities.add(ele);
        }
        return this;
    }

    public CreateProxySessionRequest withCapabilities(Collection<String> capabilities) {
        this.setCapabilities(capabilities);
        return this;
    }

    public CreateProxySessionRequest withCapabilities(Capability ... capabilities) {
        ArrayList<String> capabilitiesCopy = new ArrayList<String>(capabilities.length);
        for (Capability value : capabilities) {
            capabilitiesCopy.add(value.toString());
        }
        if (this.getCapabilities() == null) {
            this.setCapabilities(capabilitiesCopy);
        } else {
            this.getCapabilities().addAll(capabilitiesCopy);
        }
        return this;
    }

    public void setNumberSelectionBehavior(String numberSelectionBehavior) {
        this.numberSelectionBehavior = numberSelectionBehavior;
    }

    public String getNumberSelectionBehavior() {
        return this.numberSelectionBehavior;
    }

    public CreateProxySessionRequest withNumberSelectionBehavior(String numberSelectionBehavior) {
        this.setNumberSelectionBehavior(numberSelectionBehavior);
        return this;
    }

    public CreateProxySessionRequest withNumberSelectionBehavior(NumberSelectionBehavior numberSelectionBehavior) {
        this.numberSelectionBehavior = numberSelectionBehavior.toString();
        return this;
    }

    public void setGeoMatchLevel(String geoMatchLevel) {
        this.geoMatchLevel = geoMatchLevel;
    }

    public String getGeoMatchLevel() {
        return this.geoMatchLevel;
    }

    public CreateProxySessionRequest withGeoMatchLevel(String geoMatchLevel) {
        this.setGeoMatchLevel(geoMatchLevel);
        return this;
    }

    public CreateProxySessionRequest withGeoMatchLevel(GeoMatchLevel geoMatchLevel) {
        this.geoMatchLevel = geoMatchLevel.toString();
        return this;
    }

    public void setGeoMatchParams(GeoMatchParams geoMatchParams) {
        this.geoMatchParams = geoMatchParams;
    }

    public GeoMatchParams getGeoMatchParams() {
        return this.geoMatchParams;
    }

    public CreateProxySessionRequest withGeoMatchParams(GeoMatchParams geoMatchParams) {
        this.setGeoMatchParams(geoMatchParams);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getVoiceConnectorId() != null) {
            sb.append("VoiceConnectorId: ").append(this.getVoiceConnectorId()).append(",");
        }
        if (this.getParticipantPhoneNumbers() != null) {
            sb.append("ParticipantPhoneNumbers: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getExpiryMinutes() != null) {
            sb.append("ExpiryMinutes: ").append(this.getExpiryMinutes()).append(",");
        }
        if (this.getCapabilities() != null) {
            sb.append("Capabilities: ").append(this.getCapabilities()).append(",");
        }
        if (this.getNumberSelectionBehavior() != null) {
            sb.append("NumberSelectionBehavior: ").append(this.getNumberSelectionBehavior()).append(",");
        }
        if (this.getGeoMatchLevel() != null) {
            sb.append("GeoMatchLevel: ").append(this.getGeoMatchLevel()).append(",");
        }
        if (this.getGeoMatchParams() != null) {
            sb.append("GeoMatchParams: ").append(this.getGeoMatchParams());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProxySessionRequest)) {
            return false;
        }
        CreateProxySessionRequest other = (CreateProxySessionRequest)obj;
        if (other.getVoiceConnectorId() == null ^ this.getVoiceConnectorId() == null) {
            return false;
        }
        if (other.getVoiceConnectorId() != null && !other.getVoiceConnectorId().equals(this.getVoiceConnectorId())) {
            return false;
        }
        if (other.getParticipantPhoneNumbers() == null ^ this.getParticipantPhoneNumbers() == null) {
            return false;
        }
        if (other.getParticipantPhoneNumbers() != null && !other.getParticipantPhoneNumbers().equals(this.getParticipantPhoneNumbers())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getExpiryMinutes() == null ^ this.getExpiryMinutes() == null) {
            return false;
        }
        if (other.getExpiryMinutes() != null && !other.getExpiryMinutes().equals(this.getExpiryMinutes())) {
            return false;
        }
        if (other.getCapabilities() == null ^ this.getCapabilities() == null) {
            return false;
        }
        if (other.getCapabilities() != null && !other.getCapabilities().equals(this.getCapabilities())) {
            return false;
        }
        if (other.getNumberSelectionBehavior() == null ^ this.getNumberSelectionBehavior() == null) {
            return false;
        }
        if (other.getNumberSelectionBehavior() != null && !other.getNumberSelectionBehavior().equals(this.getNumberSelectionBehavior())) {
            return false;
        }
        if (other.getGeoMatchLevel() == null ^ this.getGeoMatchLevel() == null) {
            return false;
        }
        if (other.getGeoMatchLevel() != null && !other.getGeoMatchLevel().equals(this.getGeoMatchLevel())) {
            return false;
        }
        if (other.getGeoMatchParams() == null ^ this.getGeoMatchParams() == null) {
            return false;
        }
        return other.getGeoMatchParams() == null || other.getGeoMatchParams().equals(this.getGeoMatchParams());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getVoiceConnectorId() == null ? 0 : this.getVoiceConnectorId().hashCode());
        hashCode = 31 * hashCode + (this.getParticipantPhoneNumbers() == null ? 0 : this.getParticipantPhoneNumbers().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getExpiryMinutes() == null ? 0 : this.getExpiryMinutes().hashCode());
        hashCode = 31 * hashCode + (this.getCapabilities() == null ? 0 : this.getCapabilities().hashCode());
        hashCode = 31 * hashCode + (this.getNumberSelectionBehavior() == null ? 0 : this.getNumberSelectionBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getGeoMatchLevel() == null ? 0 : this.getGeoMatchLevel().hashCode());
        hashCode = 31 * hashCode + (this.getGeoMatchParams() == null ? 0 : this.getGeoMatchParams().hashCode());
        return hashCode;
    }

    public CreateProxySessionRequest clone() {
        return (CreateProxySessionRequest)super.clone();
    }
}

