/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.chime.model.Tag;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateAttendeeRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String meetingId;
    private String externalUserId;
    private List<Tag> tags;

    public void setMeetingId(String meetingId) {
        this.meetingId = meetingId;
    }

    public String getMeetingId() {
        return this.meetingId;
    }

    public CreateAttendeeRequest withMeetingId(String meetingId) {
        this.setMeetingId(meetingId);
        return this;
    }

    public void setExternalUserId(String externalUserId) {
        this.externalUserId = externalUserId;
    }

    public String getExternalUserId() {
        return this.externalUserId;
    }

    public CreateAttendeeRequest withExternalUserId(String externalUserId) {
        this.setExternalUserId(externalUserId);
        return this;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new ArrayList<Tag>(tags);
    }

    public CreateAttendeeRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags(new ArrayList<Tag>(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add(ele);
        }
        return this;
    }

    public CreateAttendeeRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMeetingId() != null) {
            sb.append("MeetingId: ").append(this.getMeetingId()).append(",");
        }
        if (this.getExternalUserId() != null) {
            sb.append("ExternalUserId: ").append("***Sensitive Data Redacted***").append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAttendeeRequest)) {
            return false;
        }
        CreateAttendeeRequest other = (CreateAttendeeRequest)obj;
        if (other.getMeetingId() == null ^ this.getMeetingId() == null) {
            return false;
        }
        if (other.getMeetingId() != null && !other.getMeetingId().equals(this.getMeetingId())) {
            return false;
        }
        if (other.getExternalUserId() == null ^ this.getExternalUserId() == null) {
            return false;
        }
        if (other.getExternalUserId() != null && !other.getExternalUserId().equals(this.getExternalUserId())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMeetingId() == null ? 0 : this.getMeetingId().hashCode());
        hashCode = 31 * hashCode + (this.getExternalUserId() == null ? 0 : this.getExternalUserId().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateAttendeeRequest clone() {
        return (CreateAttendeeRequest)super.clone();
    }
}

