/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.chime.model.MediaPlacement;

@SdkInternalApi
public class MediaPlacementMarshaller {
    private static final MarshallingInfo<String> AUDIOHOSTURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AudioHostUrl").build();
    private static final MarshallingInfo<String> AUDIOFALLBACKURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("AudioFallbackUrl").build();
    private static final MarshallingInfo<String> SCREENDATAURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScreenDataUrl").build();
    private static final MarshallingInfo<String> SCREENSHARINGURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScreenSharingUrl").build();
    private static final MarshallingInfo<String> SCREENVIEWINGURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ScreenViewingUrl").build();
    private static final MarshallingInfo<String> SIGNALINGURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("SignalingUrl").build();
    private static final MarshallingInfo<String> TURNCONTROLURL_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TurnControlUrl").build();
    private static final MediaPlacementMarshaller instance = new MediaPlacementMarshaller();

    public static MediaPlacementMarshaller getInstance() {
        return instance;
    }

    public void marshall(MediaPlacement mediaPlacement, ProtocolMarshaller protocolMarshaller) {
        if (mediaPlacement == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)mediaPlacement.getAudioHostUrl(), AUDIOHOSTURL_BINDING);
            protocolMarshaller.marshall((Object)mediaPlacement.getAudioFallbackUrl(), AUDIOFALLBACKURL_BINDING);
            protocolMarshaller.marshall((Object)mediaPlacement.getScreenDataUrl(), SCREENDATAURL_BINDING);
            protocolMarshaller.marshall((Object)mediaPlacement.getScreenSharingUrl(), SCREENSHARINGURL_BINDING);
            protocolMarshaller.marshall((Object)mediaPlacement.getScreenViewingUrl(), SCREENVIEWINGURL_BINDING);
            protocolMarshaller.marshall((Object)mediaPlacement.getSignalingUrl(), SIGNALINGURL_BINDING);
            protocolMarshaller.marshall((Object)mediaPlacement.getTurnControlUrl(), TURNCONTROLURL_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

