/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.chime.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.chime.model.AccountType;
import com.amazonaws.services.chime.model.License;
import com.amazonaws.services.chime.model.transform.AccountMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Account
implements Serializable,
Cloneable,
StructuredPojo {
    private String awsAccountId;
    private String accountId;
    private String name;
    private String accountType;
    private Date createdTimestamp;
    private String defaultLicense;
    private List<String> supportedLicenses;

    public void setAwsAccountId(String awsAccountId) {
        this.awsAccountId = awsAccountId;
    }

    public String getAwsAccountId() {
        return this.awsAccountId;
    }

    public Account withAwsAccountId(String awsAccountId) {
        this.setAwsAccountId(awsAccountId);
        return this;
    }

    public void setAccountId(String accountId) {
        this.accountId = accountId;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Account withAccountId(String accountId) {
        this.setAccountId(accountId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Account withName(String name) {
        this.setName(name);
        return this;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getAccountType() {
        return this.accountType;
    }

    public Account withAccountType(String accountType) {
        this.setAccountType(accountType);
        return this;
    }

    public Account withAccountType(AccountType accountType) {
        this.accountType = accountType.toString();
        return this;
    }

    public void setCreatedTimestamp(Date createdTimestamp) {
        this.createdTimestamp = createdTimestamp;
    }

    public Date getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public Account withCreatedTimestamp(Date createdTimestamp) {
        this.setCreatedTimestamp(createdTimestamp);
        return this;
    }

    public void setDefaultLicense(String defaultLicense) {
        this.defaultLicense = defaultLicense;
    }

    public String getDefaultLicense() {
        return this.defaultLicense;
    }

    public Account withDefaultLicense(String defaultLicense) {
        this.setDefaultLicense(defaultLicense);
        return this;
    }

    public Account withDefaultLicense(License defaultLicense) {
        this.defaultLicense = defaultLicense.toString();
        return this;
    }

    public List<String> getSupportedLicenses() {
        return this.supportedLicenses;
    }

    public void setSupportedLicenses(Collection<String> supportedLicenses) {
        if (supportedLicenses == null) {
            this.supportedLicenses = null;
            return;
        }
        this.supportedLicenses = new ArrayList<String>(supportedLicenses);
    }

    public Account withSupportedLicenses(String ... supportedLicenses) {
        if (this.supportedLicenses == null) {
            this.setSupportedLicenses(new ArrayList<String>(supportedLicenses.length));
        }
        for (String ele : supportedLicenses) {
            this.supportedLicenses.add(ele);
        }
        return this;
    }

    public Account withSupportedLicenses(Collection<String> supportedLicenses) {
        this.setSupportedLicenses(supportedLicenses);
        return this;
    }

    public Account withSupportedLicenses(License ... supportedLicenses) {
        ArrayList<String> supportedLicensesCopy = new ArrayList<String>(supportedLicenses.length);
        for (License value : supportedLicenses) {
            supportedLicensesCopy.add(value.toString());
        }
        if (this.getSupportedLicenses() == null) {
            this.setSupportedLicenses(supportedLicensesCopy);
        } else {
            this.getSupportedLicenses().addAll(supportedLicensesCopy);
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAwsAccountId() != null) {
            sb.append("AwsAccountId: ").append(this.getAwsAccountId()).append(",");
        }
        if (this.getAccountId() != null) {
            sb.append("AccountId: ").append(this.getAccountId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAccountType() != null) {
            sb.append("AccountType: ").append(this.getAccountType()).append(",");
        }
        if (this.getCreatedTimestamp() != null) {
            sb.append("CreatedTimestamp: ").append(this.getCreatedTimestamp()).append(",");
        }
        if (this.getDefaultLicense() != null) {
            sb.append("DefaultLicense: ").append(this.getDefaultLicense()).append(",");
        }
        if (this.getSupportedLicenses() != null) {
            sb.append("SupportedLicenses: ").append(this.getSupportedLicenses());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Account)) {
            return false;
        }
        Account other = (Account)obj;
        if (other.getAwsAccountId() == null ^ this.getAwsAccountId() == null) {
            return false;
        }
        if (other.getAwsAccountId() != null && !other.getAwsAccountId().equals(this.getAwsAccountId())) {
            return false;
        }
        if (other.getAccountId() == null ^ this.getAccountId() == null) {
            return false;
        }
        if (other.getAccountId() != null && !other.getAccountId().equals(this.getAccountId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAccountType() == null ^ this.getAccountType() == null) {
            return false;
        }
        if (other.getAccountType() != null && !other.getAccountType().equals(this.getAccountType())) {
            return false;
        }
        if (other.getCreatedTimestamp() == null ^ this.getCreatedTimestamp() == null) {
            return false;
        }
        if (other.getCreatedTimestamp() != null && !other.getCreatedTimestamp().equals(this.getCreatedTimestamp())) {
            return false;
        }
        if (other.getDefaultLicense() == null ^ this.getDefaultLicense() == null) {
            return false;
        }
        if (other.getDefaultLicense() != null && !other.getDefaultLicense().equals(this.getDefaultLicense())) {
            return false;
        }
        if (other.getSupportedLicenses() == null ^ this.getSupportedLicenses() == null) {
            return false;
        }
        return other.getSupportedLicenses() == null || other.getSupportedLicenses().equals(this.getSupportedLicenses());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAwsAccountId() == null ? 0 : this.getAwsAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getAccountId() == null ? 0 : this.getAccountId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAccountType() == null ? 0 : this.getAccountType().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedTimestamp() == null ? 0 : this.getCreatedTimestamp().hashCode());
        hashCode = 31 * hashCode + (this.getDefaultLicense() == null ? 0 : this.getDefaultLicense().hashCode());
        hashCode = 31 * hashCode + (this.getSupportedLicenses() == null ? 0 : this.getSupportedLicenses().hashCode());
        return hashCode;
    }

    public Account clone() {
        try {
            return (Account)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        AccountMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

