/*
 * Copyright 2017-2022 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */
package com.amazonaws.services.connectcampaign;

import javax.annotation.Generated;

import com.amazonaws.services.connectcampaign.model.*;
import com.amazonaws.*;

/**
 * Abstract implementation of {@code AmazonConnectCampaign}. Convenient method forms pass through to the corresponding
 * overload that takes a request object, which throws an {@code UnsupportedOperationException}.
 */
@Generated("com.amazonaws:aws-java-sdk-code-generator")
public class AbstractAmazonConnectCampaign implements AmazonConnectCampaign {

    protected AbstractAmazonConnectCampaign() {
    }

    @Override
    public CreateCampaignResult createCampaign(CreateCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteCampaignResult deleteCampaign(DeleteCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteConnectInstanceConfigResult deleteConnectInstanceConfig(DeleteConnectInstanceConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DeleteInstanceOnboardingJobResult deleteInstanceOnboardingJob(DeleteInstanceOnboardingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public DescribeCampaignResult describeCampaign(DescribeCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCampaignStateResult getCampaignState(GetCampaignStateRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetCampaignStateBatchResult getCampaignStateBatch(GetCampaignStateBatchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetConnectInstanceConfigResult getConnectInstanceConfig(GetConnectInstanceConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public GetInstanceOnboardingJobStatusResult getInstanceOnboardingJobStatus(GetInstanceOnboardingJobStatusRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListCampaignsResult listCampaigns(ListCampaignsRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ListTagsForResourceResult listTagsForResource(ListTagsForResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PauseCampaignResult pauseCampaign(PauseCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public PutDialRequestBatchResult putDialRequestBatch(PutDialRequestBatchRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public ResumeCampaignResult resumeCampaign(ResumeCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartCampaignResult startCampaign(StartCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StartInstanceOnboardingJobResult startInstanceOnboardingJob(StartInstanceOnboardingJobRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public StopCampaignResult stopCampaign(StopCampaignRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public TagResourceResult tagResource(TagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UntagResourceResult untagResource(UntagResourceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCampaignDialerConfigResult updateCampaignDialerConfig(UpdateCampaignDialerConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCampaignNameResult updateCampaignName(UpdateCampaignNameRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public UpdateCampaignOutboundCallConfigResult updateCampaignOutboundCallConfig(UpdateCampaignOutboundCallConfigRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public void shutdown() {
        throw new java.lang.UnsupportedOperationException();
    }

    @Override
    public com.amazonaws.ResponseMetadata getCachedResponseMetadata(com.amazonaws.AmazonWebServiceRequest request) {
        throw new java.lang.UnsupportedOperationException();
    }

}
