/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.xray.model.transform.HistogramEntryMarshaller;
import java.io.Serializable;

public class HistogramEntry
implements Serializable,
Cloneable,
StructuredPojo {
    private Double value;
    private Integer count;

    public void setValue(Double value) {
        this.value = value;
    }

    public Double getValue() {
        return this.value;
    }

    public HistogramEntry withValue(Double value) {
        this.setValue(value);
        return this;
    }

    public void setCount(Integer count) {
        this.count = count;
    }

    public Integer getCount() {
        return this.count;
    }

    public HistogramEntry withCount(Integer count) {
        this.setCount(count);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getValue() != null) {
            sb.append("Value: ").append(this.getValue()).append(",");
        }
        if (this.getCount() != null) {
            sb.append("Count: ").append(this.getCount());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HistogramEntry)) {
            return false;
        }
        HistogramEntry other = (HistogramEntry)obj;
        if (other.getValue() == null ^ this.getValue() == null) {
            return false;
        }
        if (other.getValue() != null && !other.getValue().equals(this.getValue())) {
            return false;
        }
        if (other.getCount() == null ^ this.getCount() == null) {
            return false;
        }
        return other.getCount() == null || other.getCount().equals(this.getCount());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getValue() == null ? 0 : this.getValue().hashCode());
        hashCode = 31 * hashCode + (this.getCount() == null ? 0 : this.getCount().hashCode());
        return hashCode;
    }

    public HistogramEntry clone() {
        try {
            return (HistogramEntry)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        HistogramEntryMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

