/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.xray.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.xray.model.HistogramEntry;

public class HistogramEntryJsonMarshaller {
    private static HistogramEntryJsonMarshaller instance;

    public void marshall(HistogramEntry histogramEntry, StructuredJsonGenerator jsonGenerator) {
        if (histogramEntry == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            if (histogramEntry.getValue() != null) {
                jsonGenerator.writeFieldName("Value").writeValue(histogramEntry.getValue());
            }
            if (histogramEntry.getCount() != null) {
                jsonGenerator.writeFieldName("Count").writeValue(histogramEntry.getCount());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static HistogramEntryJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new HistogramEntryJsonMarshaller();
        }
        return instance;
    }
}

