/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.gamelift.model;

import com.amazonaws.services.gamelift.model.GameProperty;
import com.amazonaws.services.gamelift.model.GameSessionStatus;
import com.amazonaws.services.gamelift.model.PlayerSessionCreationPolicy;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class GameSession
implements Serializable,
Cloneable {
    private String gameSessionId;
    private String name;
    private String fleetId;
    private Date creationTime;
    private Date terminationTime;
    private Integer currentPlayerSessionCount;
    private Integer maximumPlayerSessionCount;
    private String status;
    private List<GameProperty> gameProperties;
    private String ipAddress;
    private Integer port;
    private String playerSessionCreationPolicy;
    private String creatorId;

    public void setGameSessionId(String gameSessionId) {
        this.gameSessionId = gameSessionId;
    }

    public String getGameSessionId() {
        return this.gameSessionId;
    }

    public GameSession withGameSessionId(String gameSessionId) {
        this.setGameSessionId(gameSessionId);
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public GameSession withName(String name) {
        this.setName(name);
        return this;
    }

    public void setFleetId(String fleetId) {
        this.fleetId = fleetId;
    }

    public String getFleetId() {
        return this.fleetId;
    }

    public GameSession withFleetId(String fleetId) {
        this.setFleetId(fleetId);
        return this;
    }

    public void setCreationTime(Date creationTime) {
        this.creationTime = creationTime;
    }

    public Date getCreationTime() {
        return this.creationTime;
    }

    public GameSession withCreationTime(Date creationTime) {
        this.setCreationTime(creationTime);
        return this;
    }

    public void setTerminationTime(Date terminationTime) {
        this.terminationTime = terminationTime;
    }

    public Date getTerminationTime() {
        return this.terminationTime;
    }

    public GameSession withTerminationTime(Date terminationTime) {
        this.setTerminationTime(terminationTime);
        return this;
    }

    public void setCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
        this.currentPlayerSessionCount = currentPlayerSessionCount;
    }

    public Integer getCurrentPlayerSessionCount() {
        return this.currentPlayerSessionCount;
    }

    public GameSession withCurrentPlayerSessionCount(Integer currentPlayerSessionCount) {
        this.setCurrentPlayerSessionCount(currentPlayerSessionCount);
        return this;
    }

    public void setMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
        this.maximumPlayerSessionCount = maximumPlayerSessionCount;
    }

    public Integer getMaximumPlayerSessionCount() {
        return this.maximumPlayerSessionCount;
    }

    public GameSession withMaximumPlayerSessionCount(Integer maximumPlayerSessionCount) {
        this.setMaximumPlayerSessionCount(maximumPlayerSessionCount);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public GameSession withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setStatus(GameSessionStatus status) {
        this.status = status.toString();
    }

    public GameSession withStatus(GameSessionStatus status) {
        this.setStatus(status);
        return this;
    }

    public List<GameProperty> getGameProperties() {
        return this.gameProperties;
    }

    public void setGameProperties(Collection<GameProperty> gameProperties) {
        if (gameProperties == null) {
            this.gameProperties = null;
            return;
        }
        this.gameProperties = new ArrayList<GameProperty>(gameProperties);
    }

    public GameSession withGameProperties(GameProperty ... gameProperties) {
        if (this.gameProperties == null) {
            this.setGameProperties(new ArrayList<GameProperty>(gameProperties.length));
        }
        for (GameProperty ele : gameProperties) {
            this.gameProperties.add(ele);
        }
        return this;
    }

    public GameSession withGameProperties(Collection<GameProperty> gameProperties) {
        this.setGameProperties(gameProperties);
        return this;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public GameSession withIpAddress(String ipAddress) {
        this.setIpAddress(ipAddress);
        return this;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public Integer getPort() {
        return this.port;
    }

    public GameSession withPort(Integer port) {
        this.setPort(port);
        return this;
    }

    public void setPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
        this.playerSessionCreationPolicy = playerSessionCreationPolicy;
    }

    public String getPlayerSessionCreationPolicy() {
        return this.playerSessionCreationPolicy;
    }

    public GameSession withPlayerSessionCreationPolicy(String playerSessionCreationPolicy) {
        this.setPlayerSessionCreationPolicy(playerSessionCreationPolicy);
        return this;
    }

    public void setPlayerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
        this.playerSessionCreationPolicy = playerSessionCreationPolicy.toString();
    }

    public GameSession withPlayerSessionCreationPolicy(PlayerSessionCreationPolicy playerSessionCreationPolicy) {
        this.setPlayerSessionCreationPolicy(playerSessionCreationPolicy);
        return this;
    }

    public void setCreatorId(String creatorId) {
        this.creatorId = creatorId;
    }

    public String getCreatorId() {
        return this.creatorId;
    }

    public GameSession withCreatorId(String creatorId) {
        this.setCreatorId(creatorId);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getGameSessionId() != null) {
            sb.append("GameSessionId: ").append(this.getGameSessionId()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getFleetId() != null) {
            sb.append("FleetId: ").append(this.getFleetId()).append(",");
        }
        if (this.getCreationTime() != null) {
            sb.append("CreationTime: ").append(this.getCreationTime()).append(",");
        }
        if (this.getTerminationTime() != null) {
            sb.append("TerminationTime: ").append(this.getTerminationTime()).append(",");
        }
        if (this.getCurrentPlayerSessionCount() != null) {
            sb.append("CurrentPlayerSessionCount: ").append(this.getCurrentPlayerSessionCount()).append(",");
        }
        if (this.getMaximumPlayerSessionCount() != null) {
            sb.append("MaximumPlayerSessionCount: ").append(this.getMaximumPlayerSessionCount()).append(",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: ").append(this.getStatus()).append(",");
        }
        if (this.getGameProperties() != null) {
            sb.append("GameProperties: ").append(this.getGameProperties()).append(",");
        }
        if (this.getIpAddress() != null) {
            sb.append("IpAddress: ").append(this.getIpAddress()).append(",");
        }
        if (this.getPort() != null) {
            sb.append("Port: ").append(this.getPort()).append(",");
        }
        if (this.getPlayerSessionCreationPolicy() != null) {
            sb.append("PlayerSessionCreationPolicy: ").append(this.getPlayerSessionCreationPolicy()).append(",");
        }
        if (this.getCreatorId() != null) {
            sb.append("CreatorId: ").append(this.getCreatorId());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GameSession)) {
            return false;
        }
        GameSession other = (GameSession)obj;
        if (other.getGameSessionId() == null ^ this.getGameSessionId() == null) {
            return false;
        }
        if (other.getGameSessionId() != null && !other.getGameSessionId().equals(this.getGameSessionId())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getFleetId() == null ^ this.getFleetId() == null) {
            return false;
        }
        if (other.getFleetId() != null && !other.getFleetId().equals(this.getFleetId())) {
            return false;
        }
        if (other.getCreationTime() == null ^ this.getCreationTime() == null) {
            return false;
        }
        if (other.getCreationTime() != null && !other.getCreationTime().equals(this.getCreationTime())) {
            return false;
        }
        if (other.getTerminationTime() == null ^ this.getTerminationTime() == null) {
            return false;
        }
        if (other.getTerminationTime() != null && !other.getTerminationTime().equals(this.getTerminationTime())) {
            return false;
        }
        if (other.getCurrentPlayerSessionCount() == null ^ this.getCurrentPlayerSessionCount() == null) {
            return false;
        }
        if (other.getCurrentPlayerSessionCount() != null && !other.getCurrentPlayerSessionCount().equals(this.getCurrentPlayerSessionCount())) {
            return false;
        }
        if (other.getMaximumPlayerSessionCount() == null ^ this.getMaximumPlayerSessionCount() == null) {
            return false;
        }
        if (other.getMaximumPlayerSessionCount() != null && !other.getMaximumPlayerSessionCount().equals(this.getMaximumPlayerSessionCount())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getGameProperties() == null ^ this.getGameProperties() == null) {
            return false;
        }
        if (other.getGameProperties() != null && !other.getGameProperties().equals(this.getGameProperties())) {
            return false;
        }
        if (other.getIpAddress() == null ^ this.getIpAddress() == null) {
            return false;
        }
        if (other.getIpAddress() != null && !other.getIpAddress().equals(this.getIpAddress())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.getPlayerSessionCreationPolicy() == null ^ this.getPlayerSessionCreationPolicy() == null) {
            return false;
        }
        if (other.getPlayerSessionCreationPolicy() != null && !other.getPlayerSessionCreationPolicy().equals(this.getPlayerSessionCreationPolicy())) {
            return false;
        }
        if (other.getCreatorId() == null ^ this.getCreatorId() == null) {
            return false;
        }
        return other.getCreatorId() == null || other.getCreatorId().equals(this.getCreatorId());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getGameSessionId() == null ? 0 : this.getGameSessionId().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getFleetId() == null ? 0 : this.getFleetId().hashCode());
        hashCode = 31 * hashCode + (this.getCreationTime() == null ? 0 : this.getCreationTime().hashCode());
        hashCode = 31 * hashCode + (this.getTerminationTime() == null ? 0 : this.getTerminationTime().hashCode());
        hashCode = 31 * hashCode + (this.getCurrentPlayerSessionCount() == null ? 0 : this.getCurrentPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.getMaximumPlayerSessionCount() == null ? 0 : this.getMaximumPlayerSessionCount().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getGameProperties() == null ? 0 : this.getGameProperties().hashCode());
        hashCode = 31 * hashCode + (this.getIpAddress() == null ? 0 : this.getIpAddress().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.getPlayerSessionCreationPolicy() == null ? 0 : this.getPlayerSessionCreationPolicy().hashCode());
        hashCode = 31 * hashCode + (this.getCreatorId() == null ? 0 : this.getCreatorId().hashCode());
        return hashCode;
    }

    public GameSession clone() {
        try {
            return (GameSession)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

