/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.snowball.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.snowball.model.JobResource;
import com.amazonaws.services.snowball.model.LambdaResource;
import com.amazonaws.services.snowball.model.S3Resource;
import com.amazonaws.services.snowball.model.transform.LambdaResourceJsonMarshaller;
import com.amazonaws.services.snowball.model.transform.S3ResourceJsonMarshaller;
import java.util.List;

public class JobResourceJsonMarshaller {
    private static JobResourceJsonMarshaller instance;

    public void marshall(JobResource jobResource, StructuredJsonGenerator jsonGenerator) {
        if (jobResource == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            List<LambdaResource> lambdaResourcesList;
            jsonGenerator.writeStartObject();
            List<S3Resource> s3ResourcesList = jobResource.getS3Resources();
            if (s3ResourcesList != null) {
                jsonGenerator.writeFieldName("S3Resources");
                jsonGenerator.writeStartArray();
                for (S3Resource s3ResourcesListValue : s3ResourcesList) {
                    if (s3ResourcesListValue == null) continue;
                    S3ResourceJsonMarshaller.getInstance().marshall(s3ResourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if ((lambdaResourcesList = jobResource.getLambdaResources()) != null) {
                jsonGenerator.writeFieldName("LambdaResources");
                jsonGenerator.writeStartArray();
                for (LambdaResource lambdaResourcesListValue : lambdaResourcesList) {
                    if (lambdaResourcesListValue == null) continue;
                    LambdaResourceJsonMarshaller.getInstance().marshall(lambdaResourcesListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static JobResourceJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new JobResourceJsonMarshaller();
        }
        return instance;
    }
}

