/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.route53domains.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.route53domains.model.DeleteTagsForDomainRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DeleteTagsForDomainRequestMarshaller
implements Marshaller<Request<DeleteTagsForDomainRequest>, DeleteTagsForDomainRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteTagsForDomainRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteTagsForDomainRequest> marshall(DeleteTagsForDomainRequest deleteTagsForDomainRequest) {
        if (deleteTagsForDomainRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteTagsForDomainRequest> request = new DefaultRequest<DeleteTagsForDomainRequest>(deleteTagsForDomainRequest, "AmazonRoute53Domains");
        request.addHeader("X-Amz-Target", "Route53Domains_v20140515.DeleteTagsForDomain");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList tagsToDeleteList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (deleteTagsForDomainRequest.getDomainName() != null) {
                jsonGenerator.writeFieldName("DomainName").writeValue(deleteTagsForDomainRequest.getDomainName());
            }
            if (!(tagsToDeleteList = (SdkInternalList)deleteTagsForDomainRequest.getTagsToDelete()).isEmpty() || !tagsToDeleteList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("TagsToDelete");
                jsonGenerator.writeStartArray();
                for (String tagsToDeleteListValue : tagsToDeleteList) {
                    if (tagsToDeleteListValue == null) continue;
                    jsonGenerator.writeValue(tagsToDeleteListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

