/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.opsworks.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.opsworks.model.DescribeRaidArraysRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class DescribeRaidArraysRequestMarshaller
implements Marshaller<Request<DescribeRaidArraysRequest>, DescribeRaidArraysRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeRaidArraysRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeRaidArraysRequest> marshall(DescribeRaidArraysRequest describeRaidArraysRequest) {
        if (describeRaidArraysRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeRaidArraysRequest> request = new DefaultRequest<DescribeRaidArraysRequest>(describeRaidArraysRequest, "AWSOpsWorks");
        request.addHeader("X-Amz-Target", "OpsWorks_20130218.DescribeRaidArrays");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList raidArrayIdsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (describeRaidArraysRequest.getInstanceId() != null) {
                jsonGenerator.writeFieldName("InstanceId").writeValue(describeRaidArraysRequest.getInstanceId());
            }
            if (describeRaidArraysRequest.getStackId() != null) {
                jsonGenerator.writeFieldName("StackId").writeValue(describeRaidArraysRequest.getStackId());
            }
            if (!(raidArrayIdsList = (SdkInternalList)describeRaidArraysRequest.getRaidArrayIds()).isEmpty() || !raidArrayIdsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("RaidArrayIds");
                jsonGenerator.writeStartArray();
                for (String raidArrayIdsListValue : raidArrayIdsList) {
                    if (raidArrayIdsListValue == null) continue;
                    jsonGenerator.writeValue(raidArrayIdsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

