/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.logs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.logs.model.GetLogEventsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class GetLogEventsRequestMarshaller
implements Marshaller<Request<GetLogEventsRequest>, GetLogEventsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetLogEventsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetLogEventsRequest> marshall(GetLogEventsRequest getLogEventsRequest) {
        if (getLogEventsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetLogEventsRequest> request = new DefaultRequest<GetLogEventsRequest>(getLogEventsRequest, "AWSLogs");
        request.addHeader("X-Amz-Target", "Logs_20140328.GetLogEvents");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (getLogEventsRequest.getLogGroupName() != null) {
                jsonGenerator.writeFieldName("logGroupName").writeValue(getLogEventsRequest.getLogGroupName());
            }
            if (getLogEventsRequest.getLogStreamName() != null) {
                jsonGenerator.writeFieldName("logStreamName").writeValue(getLogEventsRequest.getLogStreamName());
            }
            if (getLogEventsRequest.getStartTime() != null) {
                jsonGenerator.writeFieldName("startTime").writeValue(getLogEventsRequest.getStartTime());
            }
            if (getLogEventsRequest.getEndTime() != null) {
                jsonGenerator.writeFieldName("endTime").writeValue(getLogEventsRequest.getEndTime());
            }
            if (getLogEventsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(getLogEventsRequest.getNextToken());
            }
            if (getLogEventsRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("limit").writeValue(getLogEventsRequest.getLimit());
            }
            if (getLogEventsRequest.getStartFromHead() != null) {
                jsonGenerator.writeFieldName("startFromHead").writeValue(getLogEventsRequest.getStartFromHead());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

