/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.ListTagsForStreamRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListTagsForStreamRequestMarshaller
implements Marshaller<Request<ListTagsForStreamRequest>, ListTagsForStreamRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListTagsForStreamRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListTagsForStreamRequest> marshall(ListTagsForStreamRequest listTagsForStreamRequest) {
        if (listTagsForStreamRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListTagsForStreamRequest> request = new DefaultRequest<ListTagsForStreamRequest>(listTagsForStreamRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.ListTagsForStream");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listTagsForStreamRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(listTagsForStreamRequest.getStreamName());
            }
            if (listTagsForStreamRequest.getExclusiveStartTagKey() != null) {
                jsonGenerator.writeFieldName("ExclusiveStartTagKey").writeValue(listTagsForStreamRequest.getExclusiveStartTagKey());
            }
            if (listTagsForStreamRequest.getLimit() != null) {
                jsonGenerator.writeFieldName("Limit").writeValue(listTagsForStreamRequest.getLimit());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

