/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.kinesis.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.kinesis.model.EnableEnhancedMonitoringRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class EnableEnhancedMonitoringRequestMarshaller
implements Marshaller<Request<EnableEnhancedMonitoringRequest>, EnableEnhancedMonitoringRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public EnableEnhancedMonitoringRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<EnableEnhancedMonitoringRequest> marshall(EnableEnhancedMonitoringRequest enableEnhancedMonitoringRequest) {
        if (enableEnhancedMonitoringRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<EnableEnhancedMonitoringRequest> request = new DefaultRequest<EnableEnhancedMonitoringRequest>(enableEnhancedMonitoringRequest, "AmazonKinesis");
        request.addHeader("X-Amz-Target", "Kinesis_20131202.EnableEnhancedMonitoring");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList shardLevelMetricsList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (enableEnhancedMonitoringRequest.getStreamName() != null) {
                jsonGenerator.writeFieldName("StreamName").writeValue(enableEnhancedMonitoringRequest.getStreamName());
            }
            if (!(shardLevelMetricsList = (SdkInternalList)enableEnhancedMonitoringRequest.getShardLevelMetrics()).isEmpty() || !shardLevelMetricsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ShardLevelMetrics");
                jsonGenerator.writeStartArray();
                for (String shardLevelMetricsListValue : shardLevelMetricsList) {
                    if (shardLevelMetricsListValue == null) continue;
                    jsonGenerator.writeValue(shardLevelMetricsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

