/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.iot.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.iot.model.DeleteThingRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class DeleteThingRequestMarshaller
implements Marshaller<Request<DeleteThingRequest>, DeleteThingRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DeleteThingRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DeleteThingRequest> marshall(DeleteThingRequest deleteThingRequest) {
        if (deleteThingRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DeleteThingRequest> request = new DefaultRequest<DeleteThingRequest>(deleteThingRequest, "AWSIot");
        request.setHttpMethod(HttpMethodName.DELETE);
        String uriResourcePath = "/things/{thingName}";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "thingName", deleteThingRequest.getThingName());
        request.setResourcePath(uriResourcePath);
        if (deleteThingRequest.getExpectedVersion() != null) {
            request.addParameter("expectedVersion", StringUtils.fromLong(deleteThingRequest.getExpectedVersion()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

