/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticsearch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.elasticsearch.model.UpdateElasticsearchDomainConfigRequest;
import com.amazonaws.services.elasticsearch.model.transform.EBSOptionsJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.ElasticsearchClusterConfigJsonMarshaller;
import com.amazonaws.services.elasticsearch.model.transform.SnapshotOptionsJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.transform.PathMarshallers;
import java.io.ByteArrayInputStream;
import java.util.Map;

public class UpdateElasticsearchDomainConfigRequestMarshaller
implements Marshaller<Request<UpdateElasticsearchDomainConfigRequest>, UpdateElasticsearchDomainConfigRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateElasticsearchDomainConfigRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateElasticsearchDomainConfigRequest> marshall(UpdateElasticsearchDomainConfigRequest updateElasticsearchDomainConfigRequest) {
        if (updateElasticsearchDomainConfigRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateElasticsearchDomainConfigRequest> request = new DefaultRequest<UpdateElasticsearchDomainConfigRequest>(updateElasticsearchDomainConfigRequest, "AWSElasticsearch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/2015-01-01/es/domain/{DomainName}/config";
        uriResourcePath = PathMarshallers.NON_GREEDY.marshall(uriResourcePath, "DomainName", updateElasticsearchDomainConfigRequest.getDomainName());
        request.setResourcePath(uriResourcePath);
        try {
            Map<String, String> advancedOptionsMap;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateElasticsearchDomainConfigRequest.getElasticsearchClusterConfig() != null) {
                jsonGenerator.writeFieldName("ElasticsearchClusterConfig");
                ElasticsearchClusterConfigJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getElasticsearchClusterConfig(), jsonGenerator);
            }
            if (updateElasticsearchDomainConfigRequest.getEBSOptions() != null) {
                jsonGenerator.writeFieldName("EBSOptions");
                EBSOptionsJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getEBSOptions(), jsonGenerator);
            }
            if (updateElasticsearchDomainConfigRequest.getSnapshotOptions() != null) {
                jsonGenerator.writeFieldName("SnapshotOptions");
                SnapshotOptionsJsonMarshaller.getInstance().marshall(updateElasticsearchDomainConfigRequest.getSnapshotOptions(), jsonGenerator);
            }
            if ((advancedOptionsMap = updateElasticsearchDomainConfigRequest.getAdvancedOptions()) != null) {
                jsonGenerator.writeFieldName("AdvancedOptions");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> advancedOptionsMapValue : advancedOptionsMap.entrySet()) {
                    if (advancedOptionsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(advancedOptionsMapValue.getKey());
                    jsonGenerator.writeValue(advancedOptionsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (updateElasticsearchDomainConfigRequest.getAccessPolicies() != null) {
                jsonGenerator.writeFieldName("AccessPolicies").writeValue(updateElasticsearchDomainConfigRequest.getAccessPolicies());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

