/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.ecs.model.UpdateContainerInstancesStateRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class UpdateContainerInstancesStateRequestMarshaller
implements Marshaller<Request<UpdateContainerInstancesStateRequest>, UpdateContainerInstancesStateRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public UpdateContainerInstancesStateRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<UpdateContainerInstancesStateRequest> marshall(UpdateContainerInstancesStateRequest updateContainerInstancesStateRequest) {
        if (updateContainerInstancesStateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<UpdateContainerInstancesStateRequest> request = new DefaultRequest<UpdateContainerInstancesStateRequest>(updateContainerInstancesStateRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.UpdateContainerInstancesState");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            SdkInternalList containerInstancesList;
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (updateContainerInstancesStateRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(updateContainerInstancesStateRequest.getCluster());
            }
            if (!(containerInstancesList = (SdkInternalList)updateContainerInstancesStateRequest.getContainerInstances()).isEmpty() || !containerInstancesList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("containerInstances");
                jsonGenerator.writeStartArray();
                for (String containerInstancesListValue : containerInstancesList) {
                    if (containerInstancesListValue == null) continue;
                    jsonGenerator.writeValue(containerInstancesListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (updateContainerInstancesStateRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(updateContainerInstancesStateRequest.getStatus());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

