/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.codedeploy.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.codedeploy.model.ELBInfo;
import com.amazonaws.services.codedeploy.model.LoadBalancerInfo;
import com.amazonaws.services.codedeploy.model.transform.ELBInfoJsonMarshaller;

public class LoadBalancerInfoJsonMarshaller {
    private static LoadBalancerInfoJsonMarshaller instance;

    public void marshall(LoadBalancerInfo loadBalancerInfo, StructuredJsonGenerator jsonGenerator) {
        if (loadBalancerInfo == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonGenerator.writeStartObject();
            SdkInternalList elbInfoListList = (SdkInternalList)loadBalancerInfo.getElbInfoList();
            if (!elbInfoListList.isEmpty() || !elbInfoListList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("elbInfoList");
                jsonGenerator.writeStartArray();
                for (ELBInfo elbInfoListListValue : elbInfoListList) {
                    if (elbInfoListListValue == null) continue;
                    ELBInfoJsonMarshaller.getInstance().marshall(elbInfoListListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LoadBalancerInfoJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LoadBalancerInfoJsonMarshaller();
        }
        return instance;
    }
}

