/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.ListDirectoriesRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class ListDirectoriesRequestMarshaller
implements Marshaller<Request<ListDirectoriesRequest>, ListDirectoriesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListDirectoriesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListDirectoriesRequest> marshall(ListDirectoriesRequest listDirectoriesRequest) {
        if (listDirectoriesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListDirectoriesRequest> request = new DefaultRequest<ListDirectoriesRequest>(listDirectoriesRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/directory/list";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listDirectoriesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listDirectoriesRequest.getNextToken());
            }
            if (listDirectoriesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listDirectoriesRequest.getMaxResults());
            }
            if (listDirectoriesRequest.getState() != null) {
                jsonGenerator.writeFieldName("state").writeValue(listDirectoriesRequest.getState());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

