/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.clouddirectory.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.clouddirectory.model.ListAttachedIndicesRequest;
import com.amazonaws.services.clouddirectory.model.transform.ObjectReferenceJsonMarshaller;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class ListAttachedIndicesRequestMarshaller
implements Marshaller<Request<ListAttachedIndicesRequest>, ListAttachedIndicesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public ListAttachedIndicesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<ListAttachedIndicesRequest> marshall(ListAttachedIndicesRequest listAttachedIndicesRequest) {
        if (listAttachedIndicesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<ListAttachedIndicesRequest> request = new DefaultRequest<ListAttachedIndicesRequest>(listAttachedIndicesRequest, "AmazonCloudDirectory");
        request.setHttpMethod(HttpMethodName.POST);
        if (listAttachedIndicesRequest.getDirectoryArn() != null) {
            request.addHeader("x-amz-data-partition", StringUtils.fromString(listAttachedIndicesRequest.getDirectoryArn()));
        }
        if (listAttachedIndicesRequest.getConsistencyLevel() != null) {
            request.addHeader("x-amz-consistency-level", StringUtils.fromString(listAttachedIndicesRequest.getConsistencyLevel()));
        }
        String uriResourcePath = "/amazonclouddirectory/2017-01-11/object/indices";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (listAttachedIndicesRequest.getTargetReference() != null) {
                jsonGenerator.writeFieldName("TargetReference");
                ObjectReferenceJsonMarshaller.getInstance().marshall(listAttachedIndicesRequest.getTargetReference(), jsonGenerator);
            }
            if (listAttachedIndicesRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("NextToken").writeValue(listAttachedIndicesRequest.getNextToken());
            }
            if (listAttachedIndicesRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("MaxResults").writeValue(listAttachedIndicesRequest.getMaxResults());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

