/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.batch.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.batch.model.DescribeJobDefinitionsRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;
import java.util.List;

public class DescribeJobDefinitionsRequestMarshaller
implements Marshaller<Request<DescribeJobDefinitionsRequest>, DescribeJobDefinitionsRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public DescribeJobDefinitionsRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<DescribeJobDefinitionsRequest> marshall(DescribeJobDefinitionsRequest describeJobDefinitionsRequest) {
        if (describeJobDefinitionsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<DescribeJobDefinitionsRequest> request = new DefaultRequest<DescribeJobDefinitionsRequest>(describeJobDefinitionsRequest, "AWSBatch");
        request.setHttpMethod(HttpMethodName.POST);
        String uriResourcePath = "/v1/describejobdefinitions";
        request.setResourcePath(uriResourcePath);
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            List<String> jobDefinitionsList = describeJobDefinitionsRequest.getJobDefinitions();
            if (jobDefinitionsList != null) {
                jsonGenerator.writeFieldName("jobDefinitions");
                jsonGenerator.writeStartArray();
                for (String jobDefinitionsListValue : jobDefinitionsList) {
                    if (jobDefinitionsListValue == null) continue;
                    jsonGenerator.writeValue(jobDefinitionsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (describeJobDefinitionsRequest.getMaxResults() != null) {
                jsonGenerator.writeFieldName("maxResults").writeValue(describeJobDefinitionsRequest.getMaxResults());
            }
            if (describeJobDefinitionsRequest.getJobDefinitionName() != null) {
                jsonGenerator.writeFieldName("jobDefinitionName").writeValue(describeJobDefinitionsRequest.getJobDefinitionName());
            }
            if (describeJobDefinitionsRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(describeJobDefinitionsRequest.getStatus());
            }
            if (describeJobDefinitionsRequest.getNextToken() != null) {
                jsonGenerator.writeFieldName("nextToken").writeValue(describeJobDefinitionsRequest.getNextToken());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            if (!request.getHeaders().containsKey("Content-Type")) {
                request.addHeader("Content-Type", this.protocolFactory.getContentType());
            }
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

