/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.apigateway.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.services.apigateway.model.GetDomainNamesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.io.ByteArrayInputStream;

public class GetDomainNamesRequestMarshaller
implements Marshaller<Request<GetDomainNamesRequest>, GetDomainNamesRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public GetDomainNamesRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<GetDomainNamesRequest> marshall(GetDomainNamesRequest getDomainNamesRequest) {
        if (getDomainNamesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<GetDomainNamesRequest> request = new DefaultRequest<GetDomainNamesRequest>(getDomainNamesRequest, "AmazonApiGateway");
        request.setHttpMethod(HttpMethodName.GET);
        String uriResourcePath = "/domainnames";
        request.setResourcePath(uriResourcePath);
        if (getDomainNamesRequest.getPosition() != null) {
            request.addParameter("position", StringUtils.fromString(getDomainNamesRequest.getPosition()));
        }
        if (getDomainNamesRequest.getLimit() != null) {
            request.addParameter("limit", StringUtils.fromInteger(getDomainNamesRequest.getLimit()));
        }
        request.setContent(new ByteArrayInputStream(new byte[0]));
        if (!request.getHeaders().containsKey("Content-Type")) {
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        return request;
    }
}

