/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servicecatalog.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.protocol.json.SdkJsonMarshallerFactory;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.servicecatalog.model.AcceptPortfolioShareRequest;
import com.amazonaws.transform.Marshaller;
import java.io.ByteArrayInputStream;

public class AcceptPortfolioShareRequestMarshaller
implements Marshaller<Request<AcceptPortfolioShareRequest>, AcceptPortfolioShareRequest> {
    private final SdkJsonMarshallerFactory protocolFactory;

    public AcceptPortfolioShareRequestMarshaller(SdkJsonMarshallerFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    @Override
    public Request<AcceptPortfolioShareRequest> marshall(AcceptPortfolioShareRequest acceptPortfolioShareRequest) {
        if (acceptPortfolioShareRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AcceptPortfolioShareRequest> request = new DefaultRequest<AcceptPortfolioShareRequest>(acceptPortfolioShareRequest, "AWSServiceCatalog");
        request.addHeader("X-Amz-Target", "AWS242ServiceCatalogService.AcceptPortfolioShare");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = this.protocolFactory.createGenerator();
            jsonGenerator.writeStartObject();
            if (acceptPortfolioShareRequest.getAcceptLanguage() != null) {
                jsonGenerator.writeFieldName("AcceptLanguage").writeValue(acceptPortfolioShareRequest.getAcceptLanguage());
            }
            if (acceptPortfolioShareRequest.getPortfolioId() != null) {
                jsonGenerator.writeFieldName("PortfolioId").writeValue(acceptPortfolioShareRequest.getPortfolioId());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent(new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", this.protocolFactory.getContentType());
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

