/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glacier;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.annotation.ThreadSafe;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.client.AwsAsyncClientParams;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.glacier.AmazonGlacierAsync;
import com.amazonaws.services.glacier.AmazonGlacierClient;
import com.amazonaws.services.glacier.model.AbortMultipartUploadRequest;
import com.amazonaws.services.glacier.model.AbortMultipartUploadResult;
import com.amazonaws.services.glacier.model.AbortVaultLockRequest;
import com.amazonaws.services.glacier.model.AbortVaultLockResult;
import com.amazonaws.services.glacier.model.AddTagsToVaultRequest;
import com.amazonaws.services.glacier.model.AddTagsToVaultResult;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.glacier.model.CompleteMultipartUploadResult;
import com.amazonaws.services.glacier.model.CompleteVaultLockRequest;
import com.amazonaws.services.glacier.model.CompleteVaultLockResult;
import com.amazonaws.services.glacier.model.CreateVaultRequest;
import com.amazonaws.services.glacier.model.CreateVaultResult;
import com.amazonaws.services.glacier.model.DeleteArchiveRequest;
import com.amazonaws.services.glacier.model.DeleteArchiveResult;
import com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.DeleteVaultAccessPolicyResult;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.DeleteVaultNotificationsResult;
import com.amazonaws.services.glacier.model.DeleteVaultRequest;
import com.amazonaws.services.glacier.model.DeleteVaultResult;
import com.amazonaws.services.glacier.model.DescribeJobRequest;
import com.amazonaws.services.glacier.model.DescribeJobResult;
import com.amazonaws.services.glacier.model.DescribeVaultRequest;
import com.amazonaws.services.glacier.model.DescribeVaultResult;
import com.amazonaws.services.glacier.model.GetDataRetrievalPolicyRequest;
import com.amazonaws.services.glacier.model.GetDataRetrievalPolicyResult;
import com.amazonaws.services.glacier.model.GetJobOutputRequest;
import com.amazonaws.services.glacier.model.GetJobOutputResult;
import com.amazonaws.services.glacier.model.GetVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.GetVaultAccessPolicyResult;
import com.amazonaws.services.glacier.model.GetVaultLockRequest;
import com.amazonaws.services.glacier.model.GetVaultLockResult;
import com.amazonaws.services.glacier.model.GetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.GetVaultNotificationsResult;
import com.amazonaws.services.glacier.model.InitiateJobRequest;
import com.amazonaws.services.glacier.model.InitiateJobResult;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.glacier.model.InitiateMultipartUploadResult;
import com.amazonaws.services.glacier.model.InitiateVaultLockRequest;
import com.amazonaws.services.glacier.model.InitiateVaultLockResult;
import com.amazonaws.services.glacier.model.ListJobsRequest;
import com.amazonaws.services.glacier.model.ListJobsResult;
import com.amazonaws.services.glacier.model.ListMultipartUploadsRequest;
import com.amazonaws.services.glacier.model.ListMultipartUploadsResult;
import com.amazonaws.services.glacier.model.ListPartsRequest;
import com.amazonaws.services.glacier.model.ListPartsResult;
import com.amazonaws.services.glacier.model.ListProvisionedCapacityRequest;
import com.amazonaws.services.glacier.model.ListProvisionedCapacityResult;
import com.amazonaws.services.glacier.model.ListTagsForVaultRequest;
import com.amazonaws.services.glacier.model.ListTagsForVaultResult;
import com.amazonaws.services.glacier.model.ListVaultsRequest;
import com.amazonaws.services.glacier.model.ListVaultsResult;
import com.amazonaws.services.glacier.model.PurchaseProvisionedCapacityRequest;
import com.amazonaws.services.glacier.model.PurchaseProvisionedCapacityResult;
import com.amazonaws.services.glacier.model.RemoveTagsFromVaultRequest;
import com.amazonaws.services.glacier.model.RemoveTagsFromVaultResult;
import com.amazonaws.services.glacier.model.SetDataRetrievalPolicyRequest;
import com.amazonaws.services.glacier.model.SetDataRetrievalPolicyResult;
import com.amazonaws.services.glacier.model.SetVaultAccessPolicyRequest;
import com.amazonaws.services.glacier.model.SetVaultAccessPolicyResult;
import com.amazonaws.services.glacier.model.SetVaultNotificationsRequest;
import com.amazonaws.services.glacier.model.SetVaultNotificationsResult;
import com.amazonaws.services.glacier.model.UploadArchiveRequest;
import com.amazonaws.services.glacier.model.UploadArchiveResult;
import com.amazonaws.services.glacier.model.UploadMultipartPartRequest;
import com.amazonaws.services.glacier.model.UploadMultipartPartResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

@ThreadSafe
public class AmazonGlacierAsyncClient
extends AmazonGlacierClient
implements AmazonGlacierAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    @Deprecated
    public AmazonGlacierAsyncClient() {
        this(DefaultAWSCredentialsProviderChain.getInstance());
    }

    @Deprecated
    public AmazonGlacierAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)DefaultAWSCredentialsProviderChain.getInstance(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonGlacierAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonGlacierAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonGlacierAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    @Deprecated
    public AmazonGlacierAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    @Deprecated
    public AmazonGlacierAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    @Deprecated
    public AmazonGlacierAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, configFactory.getConfig(), executorService);
    }

    @Deprecated
    public AmazonGlacierAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    AmazonGlacierAsyncClient(AwsAsyncClientParams asyncClientParams) {
        super(asyncClientParams);
        this.executorService = asyncClientParams.getExecutor();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<AbortMultipartUploadResult> abortMultipartUploadAsync(AbortMultipartUploadRequest request) {
        return this.abortMultipartUploadAsync(request, null);
    }

    @Override
    public Future<AbortMultipartUploadResult> abortMultipartUploadAsync(final AbortMultipartUploadRequest request, final AsyncHandler<AbortMultipartUploadRequest, AbortMultipartUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<AbortMultipartUploadResult>(){

            @Override
            public AbortMultipartUploadResult call() throws Exception {
                AbortMultipartUploadResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.abortMultipartUpload(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AbortVaultLockResult> abortVaultLockAsync(AbortVaultLockRequest request) {
        return this.abortVaultLockAsync(request, null);
    }

    @Override
    public Future<AbortVaultLockResult> abortVaultLockAsync(final AbortVaultLockRequest request, final AsyncHandler<AbortVaultLockRequest, AbortVaultLockResult> asyncHandler) {
        return this.executorService.submit(new Callable<AbortVaultLockResult>(){

            @Override
            public AbortVaultLockResult call() throws Exception {
                AbortVaultLockResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.abortVaultLock(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<AddTagsToVaultResult> addTagsToVaultAsync(AddTagsToVaultRequest request) {
        return this.addTagsToVaultAsync(request, null);
    }

    @Override
    public Future<AddTagsToVaultResult> addTagsToVaultAsync(final AddTagsToVaultRequest request, final AsyncHandler<AddTagsToVaultRequest, AddTagsToVaultResult> asyncHandler) {
        return this.executorService.submit(new Callable<AddTagsToVaultResult>(){

            @Override
            public AddTagsToVaultResult call() throws Exception {
                AddTagsToVaultResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.addTagsToVault(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CompleteMultipartUploadResult> completeMultipartUploadAsync(CompleteMultipartUploadRequest request) {
        return this.completeMultipartUploadAsync(request, null);
    }

    @Override
    public Future<CompleteMultipartUploadResult> completeMultipartUploadAsync(final CompleteMultipartUploadRequest request, final AsyncHandler<CompleteMultipartUploadRequest, CompleteMultipartUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<CompleteMultipartUploadResult>(){

            @Override
            public CompleteMultipartUploadResult call() throws Exception {
                CompleteMultipartUploadResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.completeMultipartUpload(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CompleteVaultLockResult> completeVaultLockAsync(CompleteVaultLockRequest request) {
        return this.completeVaultLockAsync(request, null);
    }

    @Override
    public Future<CompleteVaultLockResult> completeVaultLockAsync(final CompleteVaultLockRequest request, final AsyncHandler<CompleteVaultLockRequest, CompleteVaultLockResult> asyncHandler) {
        return this.executorService.submit(new Callable<CompleteVaultLockResult>(){

            @Override
            public CompleteVaultLockResult call() throws Exception {
                CompleteVaultLockResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.completeVaultLock(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateVaultResult> createVaultAsync(CreateVaultRequest request) {
        return this.createVaultAsync(request, null);
    }

    @Override
    public Future<CreateVaultResult> createVaultAsync(final CreateVaultRequest request, final AsyncHandler<CreateVaultRequest, CreateVaultResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateVaultResult>(){

            @Override
            public CreateVaultResult call() throws Exception {
                CreateVaultResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.createVault(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteArchiveResult> deleteArchiveAsync(DeleteArchiveRequest request) {
        return this.deleteArchiveAsync(request, null);
    }

    @Override
    public Future<DeleteArchiveResult> deleteArchiveAsync(final DeleteArchiveRequest request, final AsyncHandler<DeleteArchiveRequest, DeleteArchiveResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteArchiveResult>(){

            @Override
            public DeleteArchiveResult call() throws Exception {
                DeleteArchiveResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.deleteArchive(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVaultResult> deleteVaultAsync(DeleteVaultRequest request) {
        return this.deleteVaultAsync(request, null);
    }

    @Override
    public Future<DeleteVaultResult> deleteVaultAsync(final DeleteVaultRequest request, final AsyncHandler<DeleteVaultRequest, DeleteVaultResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteVaultResult>(){

            @Override
            public DeleteVaultResult call() throws Exception {
                DeleteVaultResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.deleteVault(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVaultAccessPolicyResult> deleteVaultAccessPolicyAsync(DeleteVaultAccessPolicyRequest request) {
        return this.deleteVaultAccessPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteVaultAccessPolicyResult> deleteVaultAccessPolicyAsync(final DeleteVaultAccessPolicyRequest request, final AsyncHandler<DeleteVaultAccessPolicyRequest, DeleteVaultAccessPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteVaultAccessPolicyResult>(){

            @Override
            public DeleteVaultAccessPolicyResult call() throws Exception {
                DeleteVaultAccessPolicyResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.deleteVaultAccessPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteVaultNotificationsResult> deleteVaultNotificationsAsync(DeleteVaultNotificationsRequest request) {
        return this.deleteVaultNotificationsAsync(request, null);
    }

    @Override
    public Future<DeleteVaultNotificationsResult> deleteVaultNotificationsAsync(final DeleteVaultNotificationsRequest request, final AsyncHandler<DeleteVaultNotificationsRequest, DeleteVaultNotificationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteVaultNotificationsResult>(){

            @Override
            public DeleteVaultNotificationsResult call() throws Exception {
                DeleteVaultNotificationsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.deleteVaultNotifications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(DescribeJobRequest request) {
        return this.describeJobAsync(request, null);
    }

    @Override
    public Future<DescribeJobResult> describeJobAsync(final DescribeJobRequest request, final AsyncHandler<DescribeJobRequest, DescribeJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeJobResult>(){

            @Override
            public DescribeJobResult call() throws Exception {
                DescribeJobResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.describeJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeVaultResult> describeVaultAsync(DescribeVaultRequest request) {
        return this.describeVaultAsync(request, null);
    }

    @Override
    public Future<DescribeVaultResult> describeVaultAsync(final DescribeVaultRequest request, final AsyncHandler<DescribeVaultRequest, DescribeVaultResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeVaultResult>(){

            @Override
            public DescribeVaultResult call() throws Exception {
                DescribeVaultResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.describeVault(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDataRetrievalPolicyResult> getDataRetrievalPolicyAsync(GetDataRetrievalPolicyRequest request) {
        return this.getDataRetrievalPolicyAsync(request, null);
    }

    @Override
    public Future<GetDataRetrievalPolicyResult> getDataRetrievalPolicyAsync(final GetDataRetrievalPolicyRequest request, final AsyncHandler<GetDataRetrievalPolicyRequest, GetDataRetrievalPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDataRetrievalPolicyResult>(){

            @Override
            public GetDataRetrievalPolicyResult call() throws Exception {
                GetDataRetrievalPolicyResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.getDataRetrievalPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetJobOutputResult> getJobOutputAsync(GetJobOutputRequest request) {
        return this.getJobOutputAsync(request, null);
    }

    @Override
    public Future<GetJobOutputResult> getJobOutputAsync(final GetJobOutputRequest request, final AsyncHandler<GetJobOutputRequest, GetJobOutputResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetJobOutputResult>(){

            @Override
            public GetJobOutputResult call() throws Exception {
                GetJobOutputResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.getJobOutput(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetVaultAccessPolicyResult> getVaultAccessPolicyAsync(GetVaultAccessPolicyRequest request) {
        return this.getVaultAccessPolicyAsync(request, null);
    }

    @Override
    public Future<GetVaultAccessPolicyResult> getVaultAccessPolicyAsync(final GetVaultAccessPolicyRequest request, final AsyncHandler<GetVaultAccessPolicyRequest, GetVaultAccessPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetVaultAccessPolicyResult>(){

            @Override
            public GetVaultAccessPolicyResult call() throws Exception {
                GetVaultAccessPolicyResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.getVaultAccessPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetVaultLockResult> getVaultLockAsync(GetVaultLockRequest request) {
        return this.getVaultLockAsync(request, null);
    }

    @Override
    public Future<GetVaultLockResult> getVaultLockAsync(final GetVaultLockRequest request, final AsyncHandler<GetVaultLockRequest, GetVaultLockResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetVaultLockResult>(){

            @Override
            public GetVaultLockResult call() throws Exception {
                GetVaultLockResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.getVaultLock(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetVaultNotificationsResult> getVaultNotificationsAsync(GetVaultNotificationsRequest request) {
        return this.getVaultNotificationsAsync(request, null);
    }

    @Override
    public Future<GetVaultNotificationsResult> getVaultNotificationsAsync(final GetVaultNotificationsRequest request, final AsyncHandler<GetVaultNotificationsRequest, GetVaultNotificationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetVaultNotificationsResult>(){

            @Override
            public GetVaultNotificationsResult call() throws Exception {
                GetVaultNotificationsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.getVaultNotifications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateJobResult> initiateJobAsync(InitiateJobRequest request) {
        return this.initiateJobAsync(request, null);
    }

    @Override
    public Future<InitiateJobResult> initiateJobAsync(final InitiateJobRequest request, final AsyncHandler<InitiateJobRequest, InitiateJobResult> asyncHandler) {
        return this.executorService.submit(new Callable<InitiateJobResult>(){

            @Override
            public InitiateJobResult call() throws Exception {
                InitiateJobResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.initiateJob(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateMultipartUploadResult> initiateMultipartUploadAsync(InitiateMultipartUploadRequest request) {
        return this.initiateMultipartUploadAsync(request, null);
    }

    @Override
    public Future<InitiateMultipartUploadResult> initiateMultipartUploadAsync(final InitiateMultipartUploadRequest request, final AsyncHandler<InitiateMultipartUploadRequest, InitiateMultipartUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<InitiateMultipartUploadResult>(){

            @Override
            public InitiateMultipartUploadResult call() throws Exception {
                InitiateMultipartUploadResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.initiateMultipartUpload(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateVaultLockResult> initiateVaultLockAsync(InitiateVaultLockRequest request) {
        return this.initiateVaultLockAsync(request, null);
    }

    @Override
    public Future<InitiateVaultLockResult> initiateVaultLockAsync(final InitiateVaultLockRequest request, final AsyncHandler<InitiateVaultLockRequest, InitiateVaultLockResult> asyncHandler) {
        return this.executorService.submit(new Callable<InitiateVaultLockResult>(){

            @Override
            public InitiateVaultLockResult call() throws Exception {
                InitiateVaultLockResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.initiateVaultLock(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(ListJobsRequest request) {
        return this.listJobsAsync(request, null);
    }

    @Override
    public Future<ListJobsResult> listJobsAsync(final ListJobsRequest request, final AsyncHandler<ListJobsRequest, ListJobsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListJobsResult>(){

            @Override
            public ListJobsResult call() throws Exception {
                ListJobsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listJobs(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListMultipartUploadsResult> listMultipartUploadsAsync(ListMultipartUploadsRequest request) {
        return this.listMultipartUploadsAsync(request, null);
    }

    @Override
    public Future<ListMultipartUploadsResult> listMultipartUploadsAsync(final ListMultipartUploadsRequest request, final AsyncHandler<ListMultipartUploadsRequest, ListMultipartUploadsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListMultipartUploadsResult>(){

            @Override
            public ListMultipartUploadsResult call() throws Exception {
                ListMultipartUploadsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listMultipartUploads(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListPartsResult> listPartsAsync(ListPartsRequest request) {
        return this.listPartsAsync(request, null);
    }

    @Override
    public Future<ListPartsResult> listPartsAsync(final ListPartsRequest request, final AsyncHandler<ListPartsRequest, ListPartsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListPartsResult>(){

            @Override
            public ListPartsResult call() throws Exception {
                ListPartsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listParts(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListProvisionedCapacityResult> listProvisionedCapacityAsync(ListProvisionedCapacityRequest request) {
        return this.listProvisionedCapacityAsync(request, null);
    }

    @Override
    public Future<ListProvisionedCapacityResult> listProvisionedCapacityAsync(final ListProvisionedCapacityRequest request, final AsyncHandler<ListProvisionedCapacityRequest, ListProvisionedCapacityResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListProvisionedCapacityResult>(){

            @Override
            public ListProvisionedCapacityResult call() throws Exception {
                ListProvisionedCapacityResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listProvisionedCapacity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListTagsForVaultResult> listTagsForVaultAsync(ListTagsForVaultRequest request) {
        return this.listTagsForVaultAsync(request, null);
    }

    @Override
    public Future<ListTagsForVaultResult> listTagsForVaultAsync(final ListTagsForVaultRequest request, final AsyncHandler<ListTagsForVaultRequest, ListTagsForVaultResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListTagsForVaultResult>(){

            @Override
            public ListTagsForVaultResult call() throws Exception {
                ListTagsForVaultResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listTagsForVault(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListVaultsResult> listVaultsAsync(ListVaultsRequest request) {
        return this.listVaultsAsync(request, null);
    }

    @Override
    public Future<ListVaultsResult> listVaultsAsync(final ListVaultsRequest request, final AsyncHandler<ListVaultsRequest, ListVaultsResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListVaultsResult>(){

            @Override
            public ListVaultsResult call() throws Exception {
                ListVaultsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.listVaults(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PurchaseProvisionedCapacityResult> purchaseProvisionedCapacityAsync(PurchaseProvisionedCapacityRequest request) {
        return this.purchaseProvisionedCapacityAsync(request, null);
    }

    @Override
    public Future<PurchaseProvisionedCapacityResult> purchaseProvisionedCapacityAsync(final PurchaseProvisionedCapacityRequest request, final AsyncHandler<PurchaseProvisionedCapacityRequest, PurchaseProvisionedCapacityResult> asyncHandler) {
        return this.executorService.submit(new Callable<PurchaseProvisionedCapacityResult>(){

            @Override
            public PurchaseProvisionedCapacityResult call() throws Exception {
                PurchaseProvisionedCapacityResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.purchaseProvisionedCapacity(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<RemoveTagsFromVaultResult> removeTagsFromVaultAsync(RemoveTagsFromVaultRequest request) {
        return this.removeTagsFromVaultAsync(request, null);
    }

    @Override
    public Future<RemoveTagsFromVaultResult> removeTagsFromVaultAsync(final RemoveTagsFromVaultRequest request, final AsyncHandler<RemoveTagsFromVaultRequest, RemoveTagsFromVaultResult> asyncHandler) {
        return this.executorService.submit(new Callable<RemoveTagsFromVaultResult>(){

            @Override
            public RemoveTagsFromVaultResult call() throws Exception {
                RemoveTagsFromVaultResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.removeTagsFromVault(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetDataRetrievalPolicyResult> setDataRetrievalPolicyAsync(SetDataRetrievalPolicyRequest request) {
        return this.setDataRetrievalPolicyAsync(request, null);
    }

    @Override
    public Future<SetDataRetrievalPolicyResult> setDataRetrievalPolicyAsync(final SetDataRetrievalPolicyRequest request, final AsyncHandler<SetDataRetrievalPolicyRequest, SetDataRetrievalPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetDataRetrievalPolicyResult>(){

            @Override
            public SetDataRetrievalPolicyResult call() throws Exception {
                SetDataRetrievalPolicyResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.setDataRetrievalPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetVaultAccessPolicyResult> setVaultAccessPolicyAsync(SetVaultAccessPolicyRequest request) {
        return this.setVaultAccessPolicyAsync(request, null);
    }

    @Override
    public Future<SetVaultAccessPolicyResult> setVaultAccessPolicyAsync(final SetVaultAccessPolicyRequest request, final AsyncHandler<SetVaultAccessPolicyRequest, SetVaultAccessPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetVaultAccessPolicyResult>(){

            @Override
            public SetVaultAccessPolicyResult call() throws Exception {
                SetVaultAccessPolicyResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.setVaultAccessPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetVaultNotificationsResult> setVaultNotificationsAsync(SetVaultNotificationsRequest request) {
        return this.setVaultNotificationsAsync(request, null);
    }

    @Override
    public Future<SetVaultNotificationsResult> setVaultNotificationsAsync(final SetVaultNotificationsRequest request, final AsyncHandler<SetVaultNotificationsRequest, SetVaultNotificationsResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetVaultNotificationsResult>(){

            @Override
            public SetVaultNotificationsResult call() throws Exception {
                SetVaultNotificationsResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.setVaultNotifications(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UploadArchiveResult> uploadArchiveAsync(UploadArchiveRequest request) {
        return this.uploadArchiveAsync(request, null);
    }

    @Override
    public Future<UploadArchiveResult> uploadArchiveAsync(final UploadArchiveRequest request, final AsyncHandler<UploadArchiveRequest, UploadArchiveResult> asyncHandler) {
        return this.executorService.submit(new Callable<UploadArchiveResult>(){

            @Override
            public UploadArchiveResult call() throws Exception {
                UploadArchiveResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.uploadArchive(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UploadMultipartPartResult> uploadMultipartPartAsync(UploadMultipartPartRequest request) {
        return this.uploadMultipartPartAsync(request, null);
    }

    @Override
    public Future<UploadMultipartPartResult> uploadMultipartPartAsync(final UploadMultipartPartRequest request, final AsyncHandler<UploadMultipartPartRequest, UploadMultipartPartResult> asyncHandler) {
        return this.executorService.submit(new Callable<UploadMultipartPartResult>(){

            @Override
            public UploadMultipartPartResult call() throws Exception {
                UploadMultipartPartResult result;
                try {
                    result = AmazonGlacierAsyncClient.this.uploadMultipartPart(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess(request, result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

