/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simplesystemsmanagement.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.protocol.json.StructuredJsonGenerator;
import com.amazonaws.services.simplesystemsmanagement.model.StepExecution;
import java.util.List;
import java.util.Map;

public class StepExecutionJsonMarshaller {
    private static StepExecutionJsonMarshaller instance;

    public void marshall(StepExecution stepExecution, StructuredJsonGenerator jsonGenerator) {
        if (stepExecution == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, List<String>> outputsMap;
            Map<String, String> inputsMap;
            jsonGenerator.writeStartObject();
            if (stepExecution.getStepName() != null) {
                jsonGenerator.writeFieldName("StepName").writeValue(stepExecution.getStepName());
            }
            if (stepExecution.getAction() != null) {
                jsonGenerator.writeFieldName("Action").writeValue(stepExecution.getAction());
            }
            if (stepExecution.getExecutionStartTime() != null) {
                jsonGenerator.writeFieldName("ExecutionStartTime").writeValue(stepExecution.getExecutionStartTime());
            }
            if (stepExecution.getExecutionEndTime() != null) {
                jsonGenerator.writeFieldName("ExecutionEndTime").writeValue(stepExecution.getExecutionEndTime());
            }
            if (stepExecution.getStepStatus() != null) {
                jsonGenerator.writeFieldName("StepStatus").writeValue(stepExecution.getStepStatus());
            }
            if (stepExecution.getResponseCode() != null) {
                jsonGenerator.writeFieldName("ResponseCode").writeValue(stepExecution.getResponseCode());
            }
            if ((inputsMap = stepExecution.getInputs()) != null) {
                jsonGenerator.writeFieldName("Inputs");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, String> inputsMapValue : inputsMap.entrySet()) {
                    if (inputsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(inputsMapValue.getKey());
                    jsonGenerator.writeValue(inputsMapValue.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if ((outputsMap = stepExecution.getOutputs()) != null) {
                jsonGenerator.writeFieldName("Outputs");
                jsonGenerator.writeStartObject();
                for (Map.Entry<String, List<String>> outputsMapValue : outputsMap.entrySet()) {
                    if (outputsMapValue.getValue() == null) continue;
                    jsonGenerator.writeFieldName(outputsMapValue.getKey());
                    jsonGenerator.writeStartArray();
                    for (String outputsMapValueList : outputsMapValue.getValue()) {
                        if (outputsMapValueList == null) continue;
                        jsonGenerator.writeValue(outputsMapValueList);
                    }
                    jsonGenerator.writeEndArray();
                }
                jsonGenerator.writeEndObject();
            }
            if (stepExecution.getResponse() != null) {
                jsonGenerator.writeFieldName("Response").writeValue(stepExecution.getResponse());
            }
            if (stepExecution.getFailureMessage() != null) {
                jsonGenerator.writeFieldName("FailureMessage").writeValue(stepExecution.getFailureMessage());
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new SdkClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static StepExecutionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new StepExecutionJsonMarshaller();
        }
        return instance;
    }
}

