/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.workdocs;

import com.amazonaws.annotation.NotThreadSafe;
import com.amazonaws.services.workdocs.AmazonWorkDocs;
import com.amazonaws.services.workdocs.ContentManagerAsync;
import com.amazonaws.services.workdocs.ContentManagerBuilder;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

@NotThreadSafe
public class ContentManagerAsyncBuilder
extends ContentManagerBuilder {
    private ExecutorService executorService;

    public static ContentManagerAsyncBuilder standard() {
        return new ContentManagerAsyncBuilder();
    }

    public static ContentManagerAsync defaultContentManager() {
        return ContentManagerAsyncBuilder.standard().build();
    }

    public final ContentManagerAsyncBuilder withExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public final void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public final ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public final ContentManagerAsyncBuilder withAuthenticationToken(String authenticationToken) {
        super.setAuthenticationToken(authenticationToken);
        return this;
    }

    @Override
    public final ContentManagerAsyncBuilder withWorkDocsClient(AmazonWorkDocs workDocsClient) {
        super.setWorkDocsClient(workDocsClient);
        return this;
    }

    @Override
    public ContentManagerAsync build() {
        if (this.executorService == null) {
            this.executorService = Executors.newFixedThreadPool(50);
        }
        return new ContentManagerAsync(this);
    }
}

