/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.waf.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.waf.model.RuleUpdate;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class UpdateRateBasedRuleRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String ruleId;
    private String changeToken;
    private List<RuleUpdate> updates;
    private Long rateLimit;

    public void setRuleId(String ruleId) {
        this.ruleId = ruleId;
    }

    public String getRuleId() {
        return this.ruleId;
    }

    public UpdateRateBasedRuleRequest withRuleId(String ruleId) {
        this.setRuleId(ruleId);
        return this;
    }

    public void setChangeToken(String changeToken) {
        this.changeToken = changeToken;
    }

    public String getChangeToken() {
        return this.changeToken;
    }

    public UpdateRateBasedRuleRequest withChangeToken(String changeToken) {
        this.setChangeToken(changeToken);
        return this;
    }

    public List<RuleUpdate> getUpdates() {
        return this.updates;
    }

    public void setUpdates(Collection<RuleUpdate> updates) {
        if (updates == null) {
            this.updates = null;
            return;
        }
        this.updates = new ArrayList<RuleUpdate>(updates);
    }

    public UpdateRateBasedRuleRequest withUpdates(RuleUpdate ... updates) {
        if (this.updates == null) {
            this.setUpdates(new ArrayList<RuleUpdate>(updates.length));
        }
        for (RuleUpdate ele : updates) {
            this.updates.add(ele);
        }
        return this;
    }

    public UpdateRateBasedRuleRequest withUpdates(Collection<RuleUpdate> updates) {
        this.setUpdates(updates);
        return this;
    }

    public void setRateLimit(Long rateLimit) {
        this.rateLimit = rateLimit;
    }

    public Long getRateLimit() {
        return this.rateLimit;
    }

    public UpdateRateBasedRuleRequest withRateLimit(Long rateLimit) {
        this.setRateLimit(rateLimit);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleId() != null) {
            sb.append("RuleId: ").append(this.getRuleId()).append(",");
        }
        if (this.getChangeToken() != null) {
            sb.append("ChangeToken: ").append(this.getChangeToken()).append(",");
        }
        if (this.getUpdates() != null) {
            sb.append("Updates: ").append(this.getUpdates()).append(",");
        }
        if (this.getRateLimit() != null) {
            sb.append("RateLimit: ").append(this.getRateLimit());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateRateBasedRuleRequest)) {
            return false;
        }
        UpdateRateBasedRuleRequest other = (UpdateRateBasedRuleRequest)obj;
        if (other.getRuleId() == null ^ this.getRuleId() == null) {
            return false;
        }
        if (other.getRuleId() != null && !other.getRuleId().equals(this.getRuleId())) {
            return false;
        }
        if (other.getChangeToken() == null ^ this.getChangeToken() == null) {
            return false;
        }
        if (other.getChangeToken() != null && !other.getChangeToken().equals(this.getChangeToken())) {
            return false;
        }
        if (other.getUpdates() == null ^ this.getUpdates() == null) {
            return false;
        }
        if (other.getUpdates() != null && !other.getUpdates().equals(this.getUpdates())) {
            return false;
        }
        if (other.getRateLimit() == null ^ this.getRateLimit() == null) {
            return false;
        }
        return other.getRateLimit() == null || other.getRateLimit().equals(this.getRateLimit());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleId() == null ? 0 : this.getRuleId().hashCode());
        hashCode = 31 * hashCode + (this.getChangeToken() == null ? 0 : this.getChangeToken().hashCode());
        hashCode = 31 * hashCode + (this.getUpdates() == null ? 0 : this.getUpdates().hashCode());
        hashCode = 31 * hashCode + (this.getRateLimit() == null ? 0 : this.getRateLimit().hashCode());
        return hashCode;
    }

    @Override
    public UpdateRateBasedRuleRequest clone() {
        return (UpdateRateBasedRuleRequest)super.clone();
    }
}

