/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.spring;

import com.amazonaws.services.simpleworkflow.AmazonSimpleWorkflow;
import com.amazonaws.services.simpleworkflow.flow.DataConverter;
import com.amazonaws.services.simpleworkflow.flow.WorkerBase;
import com.amazonaws.services.simpleworkflow.flow.pojo.POJOActivityImplementationFactory;
import com.amazonaws.services.simpleworkflow.flow.worker.GenericActivityWorker;
import com.amazonaws.services.simpleworkflow.model.ActivityType;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.springframework.context.SmartLifecycle;

public class SpringActivityWorker
implements WorkerBase,
SmartLifecycle {
    private final GenericActivityWorker genericWorker;
    private final POJOActivityImplementationFactory factory = new POJOActivityImplementationFactory();
    private int startPhase;
    private long terminationTimeoutSeconds = 60L;
    private boolean disableAutoStartup;

    public SpringActivityWorker() {
        this.genericWorker = new GenericActivityWorker();
        this.genericWorker.setActivityImplementationFactory(this.factory);
    }

    public SpringActivityWorker(AmazonSimpleWorkflow service, String domain, String taskListToPoll) {
        this.genericWorker = new GenericActivityWorker(service, domain, taskListToPoll);
        this.genericWorker.setActivityImplementationFactory(this.factory);
    }

    @Override
    public AmazonSimpleWorkflow getService() {
        return this.genericWorker.getService();
    }

    public void setService(AmazonSimpleWorkflow service) {
        this.genericWorker.setService(service);
    }

    @Override
    public String getDomain() {
        return this.genericWorker.getDomain();
    }

    public void setDomain(String domain) {
        this.genericWorker.setDomain(domain);
    }

    @Override
    public boolean isRegisterDomain() {
        return this.genericWorker.isRegisterDomain();
    }

    @Override
    public void setRegisterDomain(boolean registerDomain) {
        this.genericWorker.setRegisterDomain(registerDomain);
    }

    @Override
    public long getDomainRetentionPeriodInDays() {
        return this.genericWorker.getDomainRetentionPeriodInDays();
    }

    @Override
    public void setDomainRetentionPeriodInDays(long domainRetentionPeriodInDays) {
        this.genericWorker.setDomainRetentionPeriodInDays(domainRetentionPeriodInDays);
    }

    @Override
    public String getTaskListToPoll() {
        return this.genericWorker.getTaskListToPoll();
    }

    public void setTaskListToPoll(String taskListToPoll) {
        this.genericWorker.setTaskListToPoll(taskListToPoll);
    }

    public DataConverter getDataConverter() {
        return this.factory.getDataConverter();
    }

    public void setDataConverter(DataConverter dataConverter) {
        this.factory.setDataConverter(dataConverter);
    }

    @Override
    public double getMaximumPollRatePerSecond() {
        return this.genericWorker.getMaximumPollRatePerSecond();
    }

    @Override
    public void setMaximumPollRatePerSecond(double maximumPollRatePerSecond) {
        this.genericWorker.setMaximumPollRatePerSecond(maximumPollRatePerSecond);
    }

    @Override
    public int getMaximumPollRateIntervalMilliseconds() {
        return this.genericWorker.getMaximumPollRateIntervalMilliseconds();
    }

    @Override
    public void setMaximumPollRateIntervalMilliseconds(int maximumPollRateIntervalMilliseconds) {
        this.genericWorker.setMaximumPollRateIntervalMilliseconds(maximumPollRateIntervalMilliseconds);
    }

    @Override
    public String getIdentity() {
        return this.genericWorker.getIdentity();
    }

    @Override
    public void setIdentity(String identity) {
        this.genericWorker.setIdentity(identity);
    }

    @Override
    public Thread.UncaughtExceptionHandler getUncaughtExceptionHandler() {
        return this.genericWorker.getUncaughtExceptionHandler();
    }

    @Override
    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.genericWorker.setUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    @Override
    public long getPollBackoffInitialInterval() {
        return this.genericWorker.getPollBackoffInitialInterval();
    }

    @Override
    public void setPollBackoffInitialInterval(long backoffInitialInterval) {
        this.genericWorker.setPollBackoffInitialInterval(backoffInitialInterval);
    }

    @Override
    public long getPollBackoffMaximumInterval() {
        return this.genericWorker.getPollBackoffMaximumInterval();
    }

    @Override
    public void setPollBackoffMaximumInterval(long backoffMaximumInterval) {
        this.genericWorker.setPollBackoffMaximumInterval(backoffMaximumInterval);
    }

    @Override
    public double getPollBackoffCoefficient() {
        return this.genericWorker.getPollBackoffCoefficient();
    }

    @Override
    public void setPollBackoffCoefficient(double backoffCoefficient) {
        this.genericWorker.setPollBackoffCoefficient(backoffCoefficient);
    }

    @Override
    public int getPollThreadCount() {
        return this.genericWorker.getPollThreadCount();
    }

    @Override
    public void setPollThreadCount(int threadCount) {
        this.genericWorker.setPollThreadCount(threadCount);
    }

    public int getTaskExecutorThreadPoolSize() {
        return this.genericWorker.getTaskExecutorThreadPoolSize();
    }

    public void setTaskExecutorThreadPoolSize(int taskExecutorThreadPoolSize) {
        this.genericWorker.setTaskExecutorThreadPoolSize(taskExecutorThreadPoolSize);
    }

    @Override
    public boolean isDisableServiceShutdownOnStop() {
        return this.genericWorker.isDisableServiceShutdownOnStop();
    }

    @Override
    public void setDisableServiceShutdownOnStop(boolean disableServiceShutdownOnStop) {
        this.genericWorker.setDisableServiceShutdownOnStop(disableServiceShutdownOnStop);
    }

    @Override
    public void suspendPolling() {
        this.genericWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.genericWorker.resumePolling();
    }

    @Override
    public void start() {
        this.genericWorker.start();
    }

    public void stopNow() {
        this.genericWorker.shutdownNow();
    }

    @Override
    public void shutdown() {
        this.genericWorker.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.genericWorker.shutdownNow();
    }

    @Override
    public boolean shutdownAndAwaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.genericWorker.shutdownAndAwaitTermination(timeout, unit);
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.genericWorker.awaitTermination(timeout, unit);
    }

    public void stop() {
        this.shutdown();
        try {
            this.awaitTermination(this.terminationTimeoutSeconds, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public boolean isRunning() {
        return this.genericWorker.isRunning();
    }

    public void setActivitiesImplementations(Iterable<Object> activitiesImplementations) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        for (Object activitiesImplementation : activitiesImplementations) {
            this.addActivitiesImplementation(activitiesImplementation);
        }
    }

    public Iterable<Object> getActivitiesImplementations() {
        return this.factory.getActivitiesImplementations();
    }

    public List<ActivityType> addActivitiesImplementation(Object activitiesImplementation) throws InstantiationException, IllegalAccessException, SecurityException, NoSuchMethodException {
        return this.factory.addActivitiesImplementation(activitiesImplementation);
    }

    @Override
    public void registerTypesToPoll() {
        this.genericWorker.registerTypesToPoll();
    }

    public int getPhase() {
        return this.startPhase;
    }

    public void setPhase(int startPhase) {
        this.startPhase = startPhase;
    }

    public boolean isAutoStartup() {
        return !this.disableAutoStartup;
    }

    public long getTerminationTimeoutSeconds() {
        return this.terminationTimeoutSeconds;
    }

    public void setTerminationTimeoutSeconds(long terminationTimeoutSeconds) {
        this.terminationTimeoutSeconds = terminationTimeoutSeconds;
    }

    public boolean isDisableAutoStartup() {
        return this.disableAutoStartup;
    }

    public void setDisableAutoStartup(boolean disableAutoStartup) {
        this.disableAutoStartup = disableAutoStartup;
    }

    @Override
    public void setDisableTypeRegistrationOnStart(boolean disableTypeRegistrationOnStart) {
        this.genericWorker.setDisableTypeRegistrationOnStart(disableTypeRegistrationOnStart);
    }

    @Override
    public boolean isDisableTypeRegistrationOnStart() {
        return this.genericWorker.isDisableTypeRegistrationOnStart();
    }

    public void stop(Runnable callback) {
        this.stop();
        callback.run();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[genericWorker=" + this.genericWorker + ", factory=" + this.factory + "]";
    }
}

