/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.servermigration.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.servermigration.model.ReplicationJob;
import java.util.Date;
import java.util.List;

@SdkInternalApi
public class ReplicationJobMarshaller {
    private static final MarshallingInfo<String> REPLICATIONJOBID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationJobId").build();
    private static final MarshallingInfo<String> SERVERID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverId").build();
    private static final MarshallingInfo<String> SERVERTYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("serverType").build();
    private static final MarshallingInfo<StructuredPojo> VMSERVER_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("vmServer").build();
    private static final MarshallingInfo<Date> SEEDREPLICATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("seedReplicationTime").build();
    private static final MarshallingInfo<Integer> FREQUENCY_BINDING = MarshallingInfo.builder(MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("frequency").build();
    private static final MarshallingInfo<Date> NEXTREPLICATIONRUNSTARTTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextReplicationRunStartTime").build();
    private static final MarshallingInfo<String> LICENSETYPE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("licenseType").build();
    private static final MarshallingInfo<String> ROLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("roleName").build();
    private static final MarshallingInfo<String> LATESTAMIID_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("latestAmiId").build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").build();
    private static final MarshallingInfo<String> STATUSMESSAGE_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("statusMessage").build();
    private static final MarshallingInfo<String> DESCRIPTION_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("description").build();
    private static final MarshallingInfo<List> REPLICATIONRUNLIST_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("replicationRunList").build();
    private static final ReplicationJobMarshaller instance = new ReplicationJobMarshaller();

    public static ReplicationJobMarshaller getInstance() {
        return instance;
    }

    public void marshall(ReplicationJob replicationJob, ProtocolMarshaller protocolMarshaller) {
        if (replicationJob == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(replicationJob.getReplicationJobId(), REPLICATIONJOBID_BINDING);
            protocolMarshaller.marshall(replicationJob.getServerId(), SERVERID_BINDING);
            protocolMarshaller.marshall(replicationJob.getServerType(), SERVERTYPE_BINDING);
            protocolMarshaller.marshall(replicationJob.getVmServer(), VMSERVER_BINDING);
            protocolMarshaller.marshall(replicationJob.getSeedReplicationTime(), SEEDREPLICATIONTIME_BINDING);
            protocolMarshaller.marshall(replicationJob.getFrequency(), FREQUENCY_BINDING);
            protocolMarshaller.marshall(replicationJob.getNextReplicationRunStartTime(), NEXTREPLICATIONRUNSTARTTIME_BINDING);
            protocolMarshaller.marshall(replicationJob.getLicenseType(), LICENSETYPE_BINDING);
            protocolMarshaller.marshall(replicationJob.getRoleName(), ROLENAME_BINDING);
            protocolMarshaller.marshall(replicationJob.getLatestAmiId(), LATESTAMIID_BINDING);
            protocolMarshaller.marshall(replicationJob.getState(), STATE_BINDING);
            protocolMarshaller.marshall(replicationJob.getStatusMessage(), STATUSMESSAGE_BINDING);
            protocolMarshaller.marshall(replicationJob.getDescription(), DESCRIPTION_BINDING);
            protocolMarshaller.marshall(replicationJob.getReplicationRunList(), REPLICATIONRUNLIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

