/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rekognition.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.services.rekognition.model.Pose;

@SdkInternalApi
public class PoseMarshaller {
    private static final MarshallingInfo<Float> ROLL_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Roll").build();
    private static final MarshallingInfo<Float> YAW_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Yaw").build();
    private static final MarshallingInfo<Float> PITCH_BINDING = MarshallingInfo.builder(MarshallingType.FLOAT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Pitch").build();
    private static final PoseMarshaller instance = new PoseMarshaller();

    public static PoseMarshaller getInstance() {
        return instance;
    }

    public void marshall(Pose pose, ProtocolMarshaller protocolMarshaller) {
        if (pose == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(pose.getRoll(), ROLL_BINDING);
            protocolMarshaller.marshall(pose.getYaw(), YAW_BINDING);
            protocolMarshaller.marshall(pose.getPitch(), PITCH_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

