/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model.transform;

import com.amazonaws.SdkClientException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.MarshallLocation;
import com.amazonaws.protocol.MarshallingInfo;
import com.amazonaws.protocol.MarshallingType;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.glue.model.Partition;
import java.util.Date;
import java.util.List;
import java.util.Map;

@SdkInternalApi
public class PartitionMarshaller {
    private static final MarshallingInfo<List> VALUES_BINDING = MarshallingInfo.builder(MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Values").build();
    private static final MarshallingInfo<String> DATABASENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("DatabaseName").build();
    private static final MarshallingInfo<String> TABLENAME_BINDING = MarshallingInfo.builder(MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("TableName").build();
    private static final MarshallingInfo<Date> CREATIONTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("CreationTime").build();
    private static final MarshallingInfo<Date> LASTACCESSTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAccessTime").build();
    private static final MarshallingInfo<StructuredPojo> STORAGEDESCRIPTOR_BINDING = MarshallingInfo.builder(MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("StorageDescriptor").build();
    private static final MarshallingInfo<Map> PARAMETERS_BINDING = MarshallingInfo.builder(MarshallingType.MAP).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Parameters").build();
    private static final MarshallingInfo<Date> LASTANALYZEDTIME_BINDING = MarshallingInfo.builder(MarshallingType.DATE).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("LastAnalyzedTime").build();
    private static final PartitionMarshaller instance = new PartitionMarshaller();

    public static PartitionMarshaller getInstance() {
        return instance;
    }

    public void marshall(Partition partition, ProtocolMarshaller protocolMarshaller) {
        if (partition == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall(partition.getValues(), VALUES_BINDING);
            protocolMarshaller.marshall(partition.getDatabaseName(), DATABASENAME_BINDING);
            protocolMarshaller.marshall(partition.getTableName(), TABLENAME_BINDING);
            protocolMarshaller.marshall(partition.getCreationTime(), CREATIONTIME_BINDING);
            protocolMarshaller.marshall(partition.getLastAccessTime(), LASTACCESSTIME_BINDING);
            protocolMarshaller.marshall(partition.getStorageDescriptor(), STORAGEDESCRIPTOR_BINDING);
            protocolMarshaller.marshall(partition.getParameters(), PARAMETERS_BINDING);
            protocolMarshaller.marshall(partition.getLastAnalyzedTime(), LASTANALYZEDTIME_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), e);
        }
    }
}

