/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.glue.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.services.glue.model.CodeGenEdge;
import com.amazonaws.services.glue.model.CodeGenNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CreateScriptRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private List<CodeGenNode> dagNodes;
    private List<CodeGenEdge> dagEdges;

    public List<CodeGenNode> getDagNodes() {
        return this.dagNodes;
    }

    public void setDagNodes(Collection<CodeGenNode> dagNodes) {
        if (dagNodes == null) {
            this.dagNodes = null;
            return;
        }
        this.dagNodes = new ArrayList<CodeGenNode>(dagNodes);
    }

    public CreateScriptRequest withDagNodes(CodeGenNode ... dagNodes) {
        if (this.dagNodes == null) {
            this.setDagNodes(new ArrayList<CodeGenNode>(dagNodes.length));
        }
        for (CodeGenNode ele : dagNodes) {
            this.dagNodes.add(ele);
        }
        return this;
    }

    public CreateScriptRequest withDagNodes(Collection<CodeGenNode> dagNodes) {
        this.setDagNodes(dagNodes);
        return this;
    }

    public List<CodeGenEdge> getDagEdges() {
        return this.dagEdges;
    }

    public void setDagEdges(Collection<CodeGenEdge> dagEdges) {
        if (dagEdges == null) {
            this.dagEdges = null;
            return;
        }
        this.dagEdges = new ArrayList<CodeGenEdge>(dagEdges);
    }

    public CreateScriptRequest withDagEdges(CodeGenEdge ... dagEdges) {
        if (this.dagEdges == null) {
            this.setDagEdges(new ArrayList<CodeGenEdge>(dagEdges.length));
        }
        for (CodeGenEdge ele : dagEdges) {
            this.dagEdges.add(ele);
        }
        return this;
    }

    public CreateScriptRequest withDagEdges(Collection<CodeGenEdge> dagEdges) {
        this.setDagEdges(dagEdges);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDagNodes() != null) {
            sb.append("DagNodes: ").append(this.getDagNodes()).append(",");
        }
        if (this.getDagEdges() != null) {
            sb.append("DagEdges: ").append(this.getDagEdges());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateScriptRequest)) {
            return false;
        }
        CreateScriptRequest other = (CreateScriptRequest)obj;
        if (other.getDagNodes() == null ^ this.getDagNodes() == null) {
            return false;
        }
        if (other.getDagNodes() != null && !other.getDagNodes().equals(this.getDagNodes())) {
            return false;
        }
        if (other.getDagEdges() == null ^ this.getDagEdges() == null) {
            return false;
        }
        return other.getDagEdges() == null || other.getDagEdges().equals(this.getDagEdges());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDagNodes() == null ? 0 : this.getDagNodes().hashCode());
        hashCode = 31 * hashCode + (this.getDagEdges() == null ? 0 : this.getDagEdges().hashCode());
        return hashCode;
    }

    @Override
    public CreateScriptRequest clone() {
        return (CreateScriptRequest)super.clone();
    }
}

