/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elastictranscoder.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elastictranscoder.model.Pipeline;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ListPipelinesResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private SdkInternalList<Pipeline> pipelines;
    private String nextPageToken;

    public List<Pipeline> getPipelines() {
        if (this.pipelines == null) {
            this.pipelines = new SdkInternalList();
        }
        return this.pipelines;
    }

    public void setPipelines(Collection<Pipeline> pipelines) {
        if (pipelines == null) {
            this.pipelines = null;
            return;
        }
        this.pipelines = new SdkInternalList<Pipeline>(pipelines);
    }

    public ListPipelinesResult withPipelines(Pipeline ... pipelines) {
        if (this.pipelines == null) {
            this.setPipelines(new SdkInternalList<Pipeline>(pipelines.length));
        }
        for (Pipeline ele : pipelines) {
            this.pipelines.add(ele);
        }
        return this;
    }

    public ListPipelinesResult withPipelines(Collection<Pipeline> pipelines) {
        this.setPipelines(pipelines);
        return this;
    }

    public void setNextPageToken(String nextPageToken) {
        this.nextPageToken = nextPageToken;
    }

    public String getNextPageToken() {
        return this.nextPageToken;
    }

    public ListPipelinesResult withNextPageToken(String nextPageToken) {
        this.setNextPageToken(nextPageToken);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getPipelines() != null) {
            sb.append("Pipelines: ").append(this.getPipelines()).append(",");
        }
        if (this.getNextPageToken() != null) {
            sb.append("NextPageToken: ").append(this.getNextPageToken());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPipelinesResult)) {
            return false;
        }
        ListPipelinesResult other = (ListPipelinesResult)obj;
        if (other.getPipelines() == null ^ this.getPipelines() == null) {
            return false;
        }
        if (other.getPipelines() != null && !other.getPipelines().equals(this.getPipelines())) {
            return false;
        }
        if (other.getNextPageToken() == null ^ this.getNextPageToken() == null) {
            return false;
        }
        return other.getNextPageToken() == null || other.getNextPageToken().equals(this.getNextPageToken());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getPipelines() == null ? 0 : this.getPipelines().hashCode());
        hashCode = 31 * hashCode + (this.getNextPageToken() == null ? 0 : this.getNextPageToken().hashCode());
        return hashCode;
    }

    public ListPipelinesResult clone() {
        try {
            return (ListPipelinesResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

