/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.elasticbeanstalk.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.elasticbeanstalk.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class UpdateTagsForResourceRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String resourceArn;
    private SdkInternalList<Tag> tagsToAdd;
    private SdkInternalList<String> tagsToRemove;

    public void setResourceArn(String resourceArn) {
        this.resourceArn = resourceArn;
    }

    public String getResourceArn() {
        return this.resourceArn;
    }

    public UpdateTagsForResourceRequest withResourceArn(String resourceArn) {
        this.setResourceArn(resourceArn);
        return this;
    }

    public List<Tag> getTagsToAdd() {
        if (this.tagsToAdd == null) {
            this.tagsToAdd = new SdkInternalList();
        }
        return this.tagsToAdd;
    }

    public void setTagsToAdd(Collection<Tag> tagsToAdd) {
        if (tagsToAdd == null) {
            this.tagsToAdd = null;
            return;
        }
        this.tagsToAdd = new SdkInternalList<Tag>(tagsToAdd);
    }

    public UpdateTagsForResourceRequest withTagsToAdd(Tag ... tagsToAdd) {
        if (this.tagsToAdd == null) {
            this.setTagsToAdd(new SdkInternalList<Tag>(tagsToAdd.length));
        }
        for (Tag ele : tagsToAdd) {
            this.tagsToAdd.add(ele);
        }
        return this;
    }

    public UpdateTagsForResourceRequest withTagsToAdd(Collection<Tag> tagsToAdd) {
        this.setTagsToAdd(tagsToAdd);
        return this;
    }

    public List<String> getTagsToRemove() {
        if (this.tagsToRemove == null) {
            this.tagsToRemove = new SdkInternalList();
        }
        return this.tagsToRemove;
    }

    public void setTagsToRemove(Collection<String> tagsToRemove) {
        if (tagsToRemove == null) {
            this.tagsToRemove = null;
            return;
        }
        this.tagsToRemove = new SdkInternalList<String>(tagsToRemove);
    }

    public UpdateTagsForResourceRequest withTagsToRemove(String ... tagsToRemove) {
        if (this.tagsToRemove == null) {
            this.setTagsToRemove(new SdkInternalList<String>(tagsToRemove.length));
        }
        for (String ele : tagsToRemove) {
            this.tagsToRemove.add(ele);
        }
        return this;
    }

    public UpdateTagsForResourceRequest withTagsToRemove(Collection<String> tagsToRemove) {
        this.setTagsToRemove(tagsToRemove);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getResourceArn() != null) {
            sb.append("ResourceArn: ").append(this.getResourceArn()).append(",");
        }
        if (this.getTagsToAdd() != null) {
            sb.append("TagsToAdd: ").append(this.getTagsToAdd()).append(",");
        }
        if (this.getTagsToRemove() != null) {
            sb.append("TagsToRemove: ").append(this.getTagsToRemove());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTagsForResourceRequest)) {
            return false;
        }
        UpdateTagsForResourceRequest other = (UpdateTagsForResourceRequest)obj;
        if (other.getResourceArn() == null ^ this.getResourceArn() == null) {
            return false;
        }
        if (other.getResourceArn() != null && !other.getResourceArn().equals(this.getResourceArn())) {
            return false;
        }
        if (other.getTagsToAdd() == null ^ this.getTagsToAdd() == null) {
            return false;
        }
        if (other.getTagsToAdd() != null && !other.getTagsToAdd().equals(this.getTagsToAdd())) {
            return false;
        }
        if (other.getTagsToRemove() == null ^ this.getTagsToRemove() == null) {
            return false;
        }
        return other.getTagsToRemove() == null || other.getTagsToRemove().equals(this.getTagsToRemove());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getResourceArn() == null ? 0 : this.getResourceArn().hashCode());
        hashCode = 31 * hashCode + (this.getTagsToAdd() == null ? 0 : this.getTagsToAdd().hashCode());
        hashCode = 31 * hashCode + (this.getTagsToRemove() == null ? 0 : this.getTagsToRemove().hashCode());
        return hashCode;
    }

    @Override
    public UpdateTagsForResourceRequest clone() {
        return (UpdateTagsForResourceRequest)super.clone();
    }
}

