/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.transform.DeploymentConfigurationMarshaller;
import java.io.Serializable;

public class DeploymentConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer maximumPercent;
    private Integer minimumHealthyPercent;

    public void setMaximumPercent(Integer maximumPercent) {
        this.maximumPercent = maximumPercent;
    }

    public Integer getMaximumPercent() {
        return this.maximumPercent;
    }

    public DeploymentConfiguration withMaximumPercent(Integer maximumPercent) {
        this.setMaximumPercent(maximumPercent);
        return this;
    }

    public void setMinimumHealthyPercent(Integer minimumHealthyPercent) {
        this.minimumHealthyPercent = minimumHealthyPercent;
    }

    public Integer getMinimumHealthyPercent() {
        return this.minimumHealthyPercent;
    }

    public DeploymentConfiguration withMinimumHealthyPercent(Integer minimumHealthyPercent) {
        this.setMinimumHealthyPercent(minimumHealthyPercent);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getMaximumPercent() != null) {
            sb.append("MaximumPercent: ").append(this.getMaximumPercent()).append(",");
        }
        if (this.getMinimumHealthyPercent() != null) {
            sb.append("MinimumHealthyPercent: ").append(this.getMinimumHealthyPercent());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentConfiguration)) {
            return false;
        }
        DeploymentConfiguration other = (DeploymentConfiguration)obj;
        if (other.getMaximumPercent() == null ^ this.getMaximumPercent() == null) {
            return false;
        }
        if (other.getMaximumPercent() != null && !other.getMaximumPercent().equals(this.getMaximumPercent())) {
            return false;
        }
        if (other.getMinimumHealthyPercent() == null ^ this.getMinimumHealthyPercent() == null) {
            return false;
        }
        return other.getMinimumHealthyPercent() == null || other.getMinimumHealthyPercent().equals(this.getMinimumHealthyPercent());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getMaximumPercent() == null ? 0 : this.getMaximumPercent().hashCode());
        hashCode = 31 * hashCode + (this.getMinimumHealthyPercent() == null ? 0 : this.getMinimumHealthyPercent().hashCode());
        return hashCode;
    }

    public DeploymentConfiguration clone() {
        try {
            return (DeploymentConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @Override
    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        DeploymentConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

