/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.JmesPathSubExpression;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.ec2.model.DescribeInstanceStatusResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class InstanceStatusOk {
    InstanceStatusOk() {
    }

    static class IsInvalidInstanceIDNotFoundMatcher
    extends WaiterAcceptor<DescribeInstanceStatusResult> {
        IsInvalidInstanceIDNotFoundMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "InvalidInstanceID.NotFound".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.RETRY;
        }
    }

    static class IsOkMatcher
    extends WaiterAcceptor<DescribeInstanceStatusResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsOkMatcher() {
        }

        @Override
        public boolean matches(DescribeInstanceStatusResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"ok\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("InstanceStatuses")), new JmesPathSubExpression(new JmesPathField("InstanceStatus"), new JmesPathField("Status")));
        }
    }
}

