/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.transform.DescribeNetworkInterfacesRequestMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class DescribeNetworkInterfacesRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<DescribeNetworkInterfacesRequest> {
    private SdkInternalList<Filter> filters;
    private SdkInternalList<String> networkInterfaceIds;

    public List<Filter> getFilters() {
        if (this.filters == null) {
            this.filters = new SdkInternalList();
        }
        return this.filters;
    }

    public void setFilters(Collection<Filter> filters) {
        if (filters == null) {
            this.filters = null;
            return;
        }
        this.filters = new SdkInternalList<Filter>(filters);
    }

    public DescribeNetworkInterfacesRequest withFilters(Filter ... filters) {
        if (this.filters == null) {
            this.setFilters(new SdkInternalList<Filter>(filters.length));
        }
        for (Filter ele : filters) {
            this.filters.add(ele);
        }
        return this;
    }

    public DescribeNetworkInterfacesRequest withFilters(Collection<Filter> filters) {
        this.setFilters(filters);
        return this;
    }

    public List<String> getNetworkInterfaceIds() {
        if (this.networkInterfaceIds == null) {
            this.networkInterfaceIds = new SdkInternalList();
        }
        return this.networkInterfaceIds;
    }

    public void setNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
        if (networkInterfaceIds == null) {
            this.networkInterfaceIds = null;
            return;
        }
        this.networkInterfaceIds = new SdkInternalList<String>(networkInterfaceIds);
    }

    public DescribeNetworkInterfacesRequest withNetworkInterfaceIds(String ... networkInterfaceIds) {
        if (this.networkInterfaceIds == null) {
            this.setNetworkInterfaceIds(new SdkInternalList<String>(networkInterfaceIds.length));
        }
        for (String ele : networkInterfaceIds) {
            this.networkInterfaceIds.add(ele);
        }
        return this;
    }

    public DescribeNetworkInterfacesRequest withNetworkInterfaceIds(Collection<String> networkInterfaceIds) {
        this.setNetworkInterfaceIds(networkInterfaceIds);
        return this;
    }

    @Override
    public Request<DescribeNetworkInterfacesRequest> getDryRunRequest() {
        Request<DescribeNetworkInterfacesRequest> request = new DescribeNetworkInterfacesRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFilters() != null) {
            sb.append("Filters: ").append(this.getFilters()).append(",");
        }
        if (this.getNetworkInterfaceIds() != null) {
            sb.append("NetworkInterfaceIds: ").append(this.getNetworkInterfaceIds());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeNetworkInterfacesRequest)) {
            return false;
        }
        DescribeNetworkInterfacesRequest other = (DescribeNetworkInterfacesRequest)obj;
        if (other.getFilters() == null ^ this.getFilters() == null) {
            return false;
        }
        if (other.getFilters() != null && !other.getFilters().equals(this.getFilters())) {
            return false;
        }
        if (other.getNetworkInterfaceIds() == null ^ this.getNetworkInterfaceIds() == null) {
            return false;
        }
        return other.getNetworkInterfaceIds() == null || other.getNetworkInterfaceIds().equals(this.getNetworkInterfaceIds());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFilters() == null ? 0 : this.getFilters().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaceIds() == null ? 0 : this.getNetworkInterfaceIds().hashCode());
        return hashCode;
    }

    @Override
    public DescribeNetworkInterfacesRequest clone() {
        return (DescribeNetworkInterfacesRequest)super.clone();
    }
}

