/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.Origin;
import com.amazonaws.services.cloudfront.model.transform.CustomHeadersStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.CustomOriginConfigStaxUnmarshaller;
import com.amazonaws.services.cloudfront.model.transform.S3OriginConfigStaxUnmarshaller;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class OriginStaxUnmarshaller
implements Unmarshaller<Origin, StaxUnmarshallerContext> {
    private static OriginStaxUnmarshaller instance;

    @Override
    public Origin unmarshall(StaxUnmarshallerContext context) throws Exception {
        Origin origin = new Origin();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return origin;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Id", targetDepth)) {
                    origin.setId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("DomainName", targetDepth)) {
                    origin.setDomainName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("OriginPath", targetDepth)) {
                    origin.setOriginPath(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("CustomHeaders", targetDepth)) {
                    origin.setCustomHeaders(CustomHeadersStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("S3OriginConfig", targetDepth)) {
                    origin.setS3OriginConfig(S3OriginConfigStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("CustomOriginConfig", targetDepth)) continue;
                origin.setCustomOriginConfig(CustomOriginConfigStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return origin;
    }

    public static OriginStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginStaxUnmarshaller();
        }
        return instance;
    }
}

