/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudfront.model.transform;

import com.amazonaws.services.cloudfront.model.OriginSslProtocols;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class OriginSslProtocolsStaxUnmarshaller
implements Unmarshaller<OriginSslProtocols, StaxUnmarshallerContext> {
    private static OriginSslProtocolsStaxUnmarshaller instance;

    @Override
    public OriginSslProtocols unmarshall(StaxUnmarshallerContext context) throws Exception {
        OriginSslProtocols originSslProtocols = new OriginSslProtocols();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return originSslProtocols;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("Quantity", targetDepth)) {
                    originSslProtocols.setQuantity(SimpleTypeStaxUnmarshallers.IntegerStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Items", targetDepth)) {
                    originSslProtocols.withItems(new ArrayList<String>());
                    continue;
                }
                if (!context.testExpression("Items/SslProtocol", targetDepth)) continue;
                originSslProtocols.withItems(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return originSslProtocols;
    }

    public static OriginSslProtocolsStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new OriginSslProtocolsStaxUnmarshaller();
        }
        return instance;
    }
}

