/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.cloudformation.waiters;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.jmespath.JmesPathEvaluationVisitor;
import com.amazonaws.jmespath.JmesPathExpression;
import com.amazonaws.jmespath.JmesPathField;
import com.amazonaws.jmespath.JmesPathFlatten;
import com.amazonaws.jmespath.JmesPathProjection;
import com.amazonaws.jmespath.ObjectMapperSingleton;
import com.amazonaws.services.cloudformation.model.DescribeStacksResult;
import com.amazonaws.thirdparty.jackson.databind.JsonNode;
import com.amazonaws.waiters.AcceptorPathMatcher;
import com.amazonaws.waiters.WaiterAcceptor;
import com.amazonaws.waiters.WaiterState;
import java.io.IOException;

@SdkInternalApi
class StackUpdateComplete {
    StackUpdateComplete() {
    }

    static class IsValidationErrorMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        IsValidationErrorMatcher() {
        }

        @Override
        public boolean matches(AmazonServiceException e) {
            return "ValidationError".equals(e.getErrorCode());
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }
    }

    static class IsUPDATE_ROLLBACK_COMPLETEMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsUPDATE_ROLLBACK_COMPLETEMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"UPDATE_ROLLBACK_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }

    static class IsUPDATE_ROLLBACK_FAILEDMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsUPDATE_ROLLBACK_FAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"UPDATE_ROLLBACK_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }

    static class IsUPDATE_FAILEDMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsUPDATE_FAILEDMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAny(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.FAILURE;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"UPDATE_FAILED\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }

    static class IsUPDATE_COMPLETEMatcher
    extends WaiterAcceptor<DescribeStacksResult> {
        private static final JsonNode expectedResult;
        private static final JmesPathExpression ast;

        IsUPDATE_COMPLETEMatcher() {
        }

        @Override
        public boolean matches(DescribeStacksResult result) {
            Object queryNode = ObjectMapperSingleton.getObjectMapper().valueToTree(result);
            JsonNode finalResult = ast.accept(new JmesPathEvaluationVisitor(), queryNode);
            return AcceptorPathMatcher.pathAll(expectedResult, finalResult);
        }

        @Override
        public WaiterState getState() {
            return WaiterState.SUCCESS;
        }

        static {
            try {
                expectedResult = ObjectMapperSingleton.getObjectMapper().readTree("\"UPDATE_COMPLETE\"");
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
            ast = new JmesPathProjection(new JmesPathFlatten(new JmesPathField("Stacks")), new JmesPathField("StackStatus"));
        }
    }
}

