/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVpcEndpointRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVpcEndpointRequestMarshaller
implements Marshaller<Request<CreateVpcEndpointRequest>, CreateVpcEndpointRequest> {
    @Override
    public Request<CreateVpcEndpointRequest> marshall(CreateVpcEndpointRequest createVpcEndpointRequest) {
        SdkInternalList createVpcEndpointRequestSecurityGroupIdsList;
        SdkInternalList createVpcEndpointRequestSubnetIdsList;
        SdkInternalList createVpcEndpointRequestRouteTableIdsList;
        if (createVpcEndpointRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateVpcEndpointRequest> request = new DefaultRequest<CreateVpcEndpointRequest>(createVpcEndpointRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpcEndpoint");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcEndpointRequest.getVpcEndpointType() != null) {
            request.addParameter("VpcEndpointType", StringUtils.fromString(createVpcEndpointRequest.getVpcEndpointType()));
        }
        if (createVpcEndpointRequest.getVpcId() != null) {
            request.addParameter("VpcId", StringUtils.fromString(createVpcEndpointRequest.getVpcId()));
        }
        if (createVpcEndpointRequest.getServiceName() != null) {
            request.addParameter("ServiceName", StringUtils.fromString(createVpcEndpointRequest.getServiceName()));
        }
        if (createVpcEndpointRequest.getPolicyDocument() != null) {
            request.addParameter("PolicyDocument", StringUtils.fromString(createVpcEndpointRequest.getPolicyDocument()));
        }
        if (!(createVpcEndpointRequestRouteTableIdsList = (SdkInternalList)createVpcEndpointRequest.getRouteTableIds()).isEmpty() || !createVpcEndpointRequestRouteTableIdsList.isAutoConstruct()) {
            int routeTableIdsListIndex = 1;
            for (Object createVpcEndpointRequestRouteTableIdsListValue : createVpcEndpointRequestRouteTableIdsList) {
                if (createVpcEndpointRequestRouteTableIdsListValue != null) {
                    request.addParameter("RouteTableId." + routeTableIdsListIndex, StringUtils.fromString((String)createVpcEndpointRequestRouteTableIdsListValue));
                }
                ++routeTableIdsListIndex;
            }
        }
        if (!(createVpcEndpointRequestSubnetIdsList = (SdkInternalList)createVpcEndpointRequest.getSubnetIds()).isEmpty() || !createVpcEndpointRequestSubnetIdsList.isAutoConstruct()) {
            int subnetIdsListIndex = 1;
            for (String createVpcEndpointRequestSubnetIdsListValue : createVpcEndpointRequestSubnetIdsList) {
                if (createVpcEndpointRequestSubnetIdsListValue != null) {
                    request.addParameter("SubnetId." + subnetIdsListIndex, StringUtils.fromString(createVpcEndpointRequestSubnetIdsListValue));
                }
                ++subnetIdsListIndex;
            }
        }
        if (!(createVpcEndpointRequestSecurityGroupIdsList = (SdkInternalList)createVpcEndpointRequest.getSecurityGroupIds()).isEmpty() || !createVpcEndpointRequestSecurityGroupIdsList.isAutoConstruct()) {
            int securityGroupIdsListIndex = 1;
            for (String createVpcEndpointRequestSecurityGroupIdsListValue : createVpcEndpointRequestSecurityGroupIdsList) {
                if (createVpcEndpointRequestSecurityGroupIdsListValue != null) {
                    request.addParameter("SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString(createVpcEndpointRequestSecurityGroupIdsListValue));
                }
                ++securityGroupIdsListIndex;
            }
        }
        if (createVpcEndpointRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString(createVpcEndpointRequest.getClientToken()));
        }
        if (createVpcEndpointRequest.getPrivateDnsEnabled() != null) {
            request.addParameter("PrivateDnsEnabled", StringUtils.fromBoolean(createVpcEndpointRequest.getPrivateDnsEnabled()));
        }
        return request;
    }
}

